package cn.com.duiba.kjy.base.customweb.web.bind.impl;

import cn.com.duiba.kjy.base.customweb.util.ParamReflectUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.bind.ArgsResolver;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/25 4:27 下午
 * 借鉴自：org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor
 */
@Slf4j
@Order(-50)
public class RequestBodyParamResolver implements ArgsResolver {

    @Resource
    private ObjectMapper objectMapper;

    @Override
    public boolean canRead(Parameter parameter, Class<?> handlerMappingClass, Method handlerMappingMethod) {
        return parameter.isAnnotationPresent(RequestBody.class)
                && !ParamReflectUtil.isPrimitive(parameter.getType())
                && objectMapper.canDeserialize(objectMapper.getTypeFactory().constructType(parameter.getType()));
    }

    @Override
    public Object doResolver(ParameterBean parameterBean, KjjHttpRequest httpRequest, KjjHttpResponse response) {
        try {
            if (Objects.equals( httpRequest.getContentType().getMimeType(), ContentType.APPLICATION_JSON.getMimeType())) {
                return objectMapper.readValue(httpRequest.getRequestBody(), parameterBean.getJavaType());
            } else {
                return downgradeGetEmptyEntity(parameterBean);
            }
        }catch (Exception e){
            log.error("read json from netty request uri={} has error!",httpRequest.uri(),e);
            return downgradeGetEmptyEntity(parameterBean);
        }

    }

    @Override
    public void prepareResolver(ParameterBean parameterBean, Class<?> handlerMappingClass, Method handlerMappingMethod) {
        final JavaType javaType = objectMapper.getTypeFactory().constructType(parameterBean.getType());
        if (Objects.isNull(javaType)){
            throw new RuntimeException("can not reflect param for this type :"+parameterBean.getType().getName());
        }
        parameterBean.setJavaType(javaType);
    }

    @Nullable
    private Object downgradeGetEmptyEntity(ParameterBean parameterBean) {
        try {
            return parameterBean.getType().newInstance();
        } catch (InstantiationException | IllegalAccessException e) {
            log.error("there is no public and no args construct in class {}", parameterBean.getType().getName());
            return null;
        }
    }


}
