package cn.com.duiba.kjy.base.customweb.web.bind.impl;

import cn.com.duiba.kjy.base.customweb.util.ParamReflectUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.bind.ArgsResolver;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/25 6:00 下午
 * 借鉴自：org.springframework.web.servlet.mvc.method.annotation.ServletModelAttributeMethodProcessor.class
 */
@Slf4j
@Order(-1)
public class RequestEntityResolver implements ArgsResolver {

    @Resource
    private ConversionService conversionService;

    @Override
    public boolean canRead(Parameter parameter, Class<?> handlerMappingClass, Method handlerMappingMethod) {
        final ResponseBody annotation = parameter.getAnnotation(ResponseBody.class);
        if (Objects.nonNull(annotation)){
            return false;
        }
        final RequestHeader requestHeader = parameter.getAnnotation(RequestHeader.class);
        if (Objects.nonNull(requestHeader)){
            return false;
        }
        return !ParamReflectUtil.isPrimitive(parameter.getType());
    }


    @Override
    public Object doResolver(ParameterBean parameterBean, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Exception {
//        try {
//            final Object param = parameterBean.getType().newInstance();
//            final MultiValueMap<String, String> paramMap = httpRequest.getParamMap();
//            for (String name : paramMap.keySet()) {
//                final String first = paramMap.getFirst(name);
//                try {
//                    BeanUtils.setProperty(param,name,first);
//                } catch (InvocationTargetException e) {
//                    e.printStackTrace();
//                }
//            }
//            return param;
//        } catch (InstantiationException | IllegalAccessException e) {
//            return null;
//        }
        final Object param = parameterBean.getType().newInstance();
        WebDataBinder webDataBinder = new WebDataBinder(param,parameterBean.getName());
        webDataBinder.setConversionService(conversionService);
        MutablePropertyValues pvs = new MutablePropertyValues();
        bindMultipart(httpRequest.getParamMap(),pvs);
        webDataBinder.bind(pvs);
        return param;
    }



    protected void bindMultipart(MultiValueMap<String, String> multipartFiles, MutablePropertyValues mpvs) {
        multipartFiles.forEach((key, values) -> {
            if (values.size() == 1) {
                mpvs.add(key, values.get(0));
            }
            else {
                mpvs.add(key, values);
            }
        });
    }
}
