package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMapping;
import com.alibaba.fastjson.JSON;
import org.springframework.boot.actuate.beans.BeansEndpoint;

import javax.annotation.Resource;

/**
 * @author dugq
 * @date 2021/3/28 4:47 下午
 */
public class ActuateFilter implements CustomFilter{
    @Resource
    private BeansEndpoint beansEndpoint;
    @Resource
    private ControllerMapping controllerMapping;

    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        if (SpringEnvironmentUtils.isProdEnv()){
            customFilterChain.filter(httpRequest, response);
            return;
        }
        final String path = httpRequest.getUri().getPath();
        switch (path){
            case "/beans":
                final BeansEndpoint.ApplicationBeans beans = beansEndpoint.beans();
                response.write(JSON.toJSONString(beans));
                response.flushAndClose();
                return;
            case "/mappings":
                response.write(JSON.toJSONString(controllerMapping.getHandlerList()));
                response.flushAndClose();
                return;
            default:customFilterChain.filter(httpRequest, response);
        }
    }
}
