package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.util.PerfTestUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AbstractAccessLogFilter;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author dugq
 * @date 2021/3/30 5:53 下午
 */
@Slf4j
public class KjjAccessLogFilter extends AbstractAccessLogFilter<KjjHttpRequest,KjjHttpResponse> implements CustomFilter{

    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            doBefore(httpRequest, response);
            customFilterChain.filter(httpRequest, response);
        }finally {
            doAfter(httpRequest, response, System.currentTimeMillis() - start);
        }
    }

    @Override
    protected String getRequestURI(KjjHttpRequest req) {
        return req.getRequestURI();
    }

    @Override
    protected String getMethod(KjjHttpRequest req) {
        return req.getMethod();
    }

    @Override
    protected String getQueryString(KjjHttpRequest req) {
        return req.getQueryString();
    }

    @Override
    protected String getHeader(KjjHttpRequest req, String key) {
        return req.getHeader(key);
    }

    @Override
    protected String getIpAddr(KjjHttpRequest req) {
        return req.getIpAddr();
    }

    @Override
    protected boolean isPerfTestRequest(KjjHttpRequest req) {
        return PerfTestUtil.isPerfTestRequest(req);
    }

    @Override
    protected void addAttribute(KjjHttpRequest req, String key, Object value) {
        req.addAttribute(key,value);
    }

    @Override
    protected Object getAttribute(KjjHttpRequest req, String key) {
        return req.getAttribute(key);
    }

    @Override
    protected String getParameter(KjjHttpRequest req, String key) {
        return req.getParameter(key);
    }

    @Override
    protected List<String> getParameterNames(KjjHttpRequest req) {
        return new ArrayList<>(req.getParamMap().keySet());
    }

    @Override
    protected int getStatus(KjjHttpResponse resp) {
        return resp.getResponse().status().code();
    }

    @Override
    protected void addCookie(KjjHttpResponse resp, String key, String value, String domain, String path) {
        Cookie cookie = new DefaultCookie(key, value);
        if(domain != null){
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        resp.addCookie(cookie);
    }

    @Override
    protected Map<String, String> getCookieMap(KjjHttpRequest req) {
       return req.getCookies().stream().collect(Collectors.toMap(Cookie::name,Cookie::value,(left,right)->left));
    }

    @Override
    protected void ensureSafeCall() {
        String threadName = StringUtils.defaultString(Thread.currentThread().getName());
        if (!threadName.startsWith("netty")){
            log.error("can not use accessLogger out of netty work thread!");
        }
    }
}
