package cn.com.duiba.kjy.base.customweb.web.handler.exception;

import cn.com.duiba.kjy.base.customweb.exception.ExceptionHandlerException;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author dugq
 * @date 2021/3/28 11:34 下午
 */
@Slf4j
public class ExceptionChain {
    @Resource
    private DefaultExceptionHandler defaultExceptionHandler;

    private final List<ExceptionHandler> exceptionHandlerList;

    public ExceptionChain(List<ExceptionHandler> exceptionHandlerList) {
        this.exceptionHandlerList = exceptionHandlerList;
    }


    public void handlerException(KjjHttpRequest request, KjjHttpResponse response, Throwable e) {
        try {
            for (ExceptionHandler exceptionHandler : exceptionHandlerList) {
                if (exceptionHandler.doHandler(request,response,e)){
                    return;
                }
            }
        }catch (Exception e2){
            defaultExceptionHandler.doHandler(request, response, new ExceptionHandlerException(e,e2));
        }

    }
}
