package cn.com.duiba.kjy.base.customweb.web.handler.mapping;

import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.interceptor.KjjInterceptor;
import lombok.Getter;

import java.util.List;

/**
 * @author dugq
 * @date 2021/3/29 4:50 下午
 */
@Getter
public class HandlerExecutionChain {

    private final List<KjjInterceptor> interceptors;
    private final RequestMappings requestMappings;
    private final Object handler;

    public boolean applyPreHandle(KjjHttpRequest fullHttpRequest, KjjHttpResponse response, Object controllerMappingHandler){
        for (KjjInterceptor kjjInterceptor : interceptors) {
            if (kjjInterceptor.applyPreHandle(fullHttpRequest,response, controllerMappingHandler)){
                return true;
            }
        }
        return false;
    }

    public void applyPostHandle(KjjHttpRequest fullHttpRequest, KjjHttpResponse response, Object handler, Object result){
        for (KjjInterceptor kjjInterceptor : interceptors) {
            kjjInterceptor.applyPostHandle(fullHttpRequest,response, handler,result);
        }
    }

    public HandlerExecutionChain(List<KjjInterceptor> kjjInterceptors, RequestMappings requestMappings, Object handler) {
        this.requestMappings = requestMappings;
        this.interceptors = kjjInterceptors;
        this.handler = handler;
    }

    public RequestHandlerMappingAdaptor getAdaptor(){
        return requestMappings.getAdaptor();
    }

}
