package cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller;


import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.RequestMappings;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/29 3:37 下午
 */
public class ControllerMapping implements RequestMappings {
    @Resource
    private RequestHandlerMappingAdaptor requestHandlerMappingAdaptor;

    private final Map<String, ControllerMappingHandler> HANDLER_MAPPING_BEAN_MAP = new HashMap<>();


    public void registerHandler(ControllerMappingHandler controllerMappingHandler) {
        if (Objects.isNull(controllerMappingHandler)){
            return;
        }
        HANDLER_MAPPING_BEAN_MAP.put(controllerMappingHandler.getUrl(), controllerMappingHandler);
    }

    @Override
    public Object getHandler(KjjHttpRequest fullHttpRequest){
        final String path = fullHttpRequest.getUri().getPath();
        return HANDLER_MAPPING_BEAN_MAP.get(path);
    }

    @Override
    public RequestHandlerMappingAdaptor getAdaptor(){
        return requestHandlerMappingAdaptor;
    }

    public Collection<ControllerMappingHandler> getHandlerList(){
        return HANDLER_MAPPING_BEAN_MAP.values();
    }
}
