package cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller;

import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.bean.RequestTypeEnum;
import cn.com.duiba.kjy.base.customweb.web.handler.response.ResponseHandler;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.lang.reflect.Method;
import java.util.List;

/**
 * @author dugq
 * @date 2021/3/23 7:16 下午
 */
@Data
public class ControllerMappingHandlerBuilder {

    private Class<?> handlerClass;

    private Method handlerMethod;

    private List<ParameterBean> paramList;

    private RequestTypeEnum requestType;

    private String url;

    private Class<?> returnType;

    private Object handlerObject;

    private ResponseHandler responseHandler;

    public ControllerMappingHandler build(){
        if (StringUtils.isBlank(url)){
            url = "/";
        }
        return new ControllerMappingHandler(handlerClass,handlerMethod,paramList,requestType,url,returnType,handlerObject,responseHandler);
    }

    public static ControllerMappingHandlerBuilder create(Class<?> handlerBeanClass, Method method){
        final ControllerMappingHandlerBuilder controllerMappingHandlerBuilder = new ControllerMappingHandlerBuilder();
        controllerMappingHandlerBuilder.setHandlerMethod(method);
        controllerMappingHandlerBuilder.setHandlerClass(handlerBeanClass);
        return controllerMappingHandlerBuilder;
    }

}
