package cn.com.duiba.kjy.base.customweb.web.processor;

import cn.com.duiba.kjy.base.customweb.web.factory.HandlerMappingBeanFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/23 7:11 下午
 */
@Slf4j
public class ControllerBeanPostProcessor implements BeanPostProcessor {

    @Resource
    private HandlerMappingBeanFactory handlerMappingBeanFactory;

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        final Class<?> beanClass = bean.getClass();
        final Annotation ctrlAnnotation = getControllerAnnotation(beanClass);
        if (Objects.isNull(ctrlAnnotation)){
            return bean;
        }
        List<Method> hanMethodList = new ArrayList<>();
        for (Method handleMethod : beanClass.getDeclaredMethods()){
            if (handleMethod.isAnnotationPresent(GetMapping.class) || handleMethod.isAnnotationPresent(PostMapping.class) || handleMethod.isAnnotationPresent(RequestMapping.class)){
                hanMethodList.add(handleMethod);
            }
        }
        handlerMappingBeanFactory.builderHandlerMappingAndRegister(beanClass,hanMethodList,bean);
        return bean;
    }

    private Annotation getControllerAnnotation(Class<?> beanClass) {
        final Annotation controllerAnnotation = beanClass.getDeclaredAnnotation(Controller.class);
        if (Objects.nonNull(controllerAnnotation)){
            return controllerAnnotation;
        }
        return beanClass.getDeclaredAnnotation(RestController.class);
    }

}
