package cn.com.duiba.kjy.base.reactive.convert;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Created by dugq on 2019-05-13.
 * 自动解密参数：
 * get方式提交参数：
 * 例： fun(@IdDecode Long a);
 * fun(Object obj);  此时Object需要在Object类上加@IdDecode注解 以及ID上加注解
 *
 *   @IdDecode
 *   class Param{
 *      @IdDecode
 *      Long id;
 *      String title;
 *   }
 *
 * post方式：
 * fun(@RequestBody Object obj);  Object需要在Object类上加@IdDecode注解 同上
 *
 * 具体的参数配置，看属性描述
 */
@Target({ElementType.PARAMETER,ElementType.TYPE,ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface IdDecode {

    /**
     * 解密数组和集合类型的时候必填
     * 因为java范型获取不到具体类型，无法解析。需要显示指定
     * 声明： 不支持map。理由： map本身不适合做param，其次，map的加入将会让数据结构复杂度大增，不利于解析
     * @return
     */
    Class type() default Object.class;

}
