/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.bind.impl;

import cn.com.duiba.kjy.base.customweb.util.ParamReflectUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.bind.ArgsResolver;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.RequestBody;

@Order(value=-50)
public class RequestBodyParamResolver
implements ArgsResolver {
    private static final Logger log = LoggerFactory.getLogger(RequestBodyParamResolver.class);
    @Resource
    private ObjectMapper objectMapper;

    @Override
    public boolean canRead(Parameter parameter, Class<?> handlerMappingClass, Method handlerMappingMethod) {
        return parameter.isAnnotationPresent(RequestBody.class) && !ParamReflectUtil.isPrimitive(parameter.getType()) && this.objectMapper.canDeserialize(this.objectMapper.getTypeFactory().constructType(parameter.getType()));
    }

    @Override
    public Object doResolver(ParameterBean parameterBean, KjjHttpRequest httpRequest, KjjHttpResponse response) {
        try {
            if (Objects.equals(httpRequest.getContentType().getMimeType(), ContentType.APPLICATION_JSON.getMimeType())) {
                return this.objectMapper.readValue(httpRequest.getRequestBody(), parameterBean.getJavaType());
            }
            return this.downgradeGetEmptyEntity(parameterBean);
        }
        catch (Exception e) {
            log.error("read json from netty request uri={} has error!", (Object)httpRequest.uri(), (Object)e);
            return this.downgradeGetEmptyEntity(parameterBean);
        }
    }

    @Override
    public void prepareResolver(ParameterBean parameterBean, Class<?> handlerMappingClass, Method handlerMappingMethod) {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(parameterBean.getType());
        if (Objects.isNull(javaType)) {
            throw new RuntimeException("can not reflect param for this type :" + parameterBean.getType().getName());
        }
        parameterBean.setJavaType(javaType);
    }

    @Nullable
    private Object downgradeGetEmptyEntity(ParameterBean parameterBean) {
        try {
            return parameterBean.getType().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("there is no public and no args construct in class {}", (Object)parameterBean.getType().getName());
            return null;
        }
    }
}

