/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.util.PerfTestUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilterChain;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AbstractAccessLogFilter;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KjjAccessLogFilter
extends AbstractAccessLogFilter<KjjHttpRequest, KjjHttpResponse>
implements CustomFilter {
    private static final Logger log = LoggerFactory.getLogger(KjjAccessLogFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            this.doBefore(httpRequest, response);
            customFilterChain.filter(httpRequest, response);
        }
        finally {
            this.doAfter(httpRequest, response, System.currentTimeMillis() - start);
        }
    }

    protected String getRequestURI(KjjHttpRequest req) {
        return req.getRequestURI();
    }

    protected String getMethod(KjjHttpRequest req) {
        return req.getMethod();
    }

    protected String getQueryString(KjjHttpRequest req) {
        return req.getQueryString();
    }

    protected String getHeader(KjjHttpRequest req, String key) {
        return req.getHeader(key);
    }

    protected String getIpAddr(KjjHttpRequest req) {
        return req.getIpAddr();
    }

    protected boolean isPerfTestRequest(KjjHttpRequest req) {
        return PerfTestUtil.isPerfTestRequest(req);
    }

    protected void addAttribute(KjjHttpRequest req, String key, Object value) {
        req.addAttribute(key, value);
    }

    protected Object getAttribute(KjjHttpRequest req, String key) {
        return req.getAttribute(key);
    }

    protected String getParameter(KjjHttpRequest req, String key) {
        return req.getParameter(key);
    }

    protected List<String> getParameterNames(KjjHttpRequest req) {
        return new ArrayList<String>(req.getParamMap().keySet());
    }

    protected int getStatus(KjjHttpResponse resp) {
        return resp.getResponse().status().code();
    }

    protected void addCookie(KjjHttpResponse resp, String key, String value, String domain, String path) {
        DefaultCookie cookie = new DefaultCookie(key, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        resp.addCookie((Cookie)cookie);
    }

    protected Map<String, String> getCookieMap(KjjHttpRequest req) {
        return req.getCookies().stream().collect(Collectors.toMap(Cookie::name, Cookie::value, (left, right) -> left));
    }

    protected void ensureSafeCall() {
        String threadName = StringUtils.defaultString((String)Thread.currentThread().getName());
        if (!threadName.startsWith("netty")) {
            log.error("can not use accessLogger out of netty work thread!");
        }
    }
}

