/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.handler.exception;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.ControllerAdviceBean;
import org.springframework.web.method.annotation.ExceptionHandlerMethodResolver;

public class ControllerAdviceHandler
implements ExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerAdviceHandler.class);
    private final Map<ControllerAdviceBean, ExceptionHandlerMethodResolver> exceptionHandler = new HashMap<ControllerAdviceBean, ExceptionHandlerMethodResolver>();
    private final ObjectMapper objectMapper;

    public ControllerAdviceHandler(List<ControllerAdviceBean> adviceBeans, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        adviceBeans.stream().filter(adviceBean -> Objects.nonNull(adviceBean.getBeanType())).forEach(adviceBean -> {
            ExceptionHandlerMethodResolver exceptionHandlerMethodResolver = new ExceptionHandlerMethodResolver(adviceBean.getBeanType());
            this.exceptionHandler.put((ControllerAdviceBean)adviceBean, exceptionHandlerMethodResolver);
        });
    }

    @Override
    public boolean doHandler(KjjHttpRequest request, KjjHttpResponse response, Throwable throwable) {
        if (!(throwable instanceof Exception)) {
            return false;
        }
        for (Map.Entry<ControllerAdviceBean, ExceptionHandlerMethodResolver> entry : this.exceptionHandler.entrySet()) {
            Method method = entry.getValue().resolveMethodByExceptionType(throwable.getClass());
            if (Objects.isNull(method)) continue;
            try {
                Object[] args = this.getArgs(request, response, (Exception)throwable, method);
                Object result = method.invoke(entry.getKey().resolveBean(), args);
                if (Objects.nonNull(result)) {
                    String responseBody = this.objectMapper.writeValueAsString(result);
                    response.write(responseBody);
                }
                response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
                response.flushAndClose();
                return true;
            }
            catch (Exception e) {
                log.error("handler exception has error in controller advice", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private Object[] getArgs(KjjHttpRequest request, KjjHttpResponse response, Exception exception, Method method) {
        int parameterCount = method.getParameterCount();
        Object[] args = new Object[parameterCount];
        Parameter[] parameters = method.getParameters();
        int index = 0;
        for (Parameter parameter : parameters) {
            if (Objects.equals(parameter.getType(), KjjHttpRequest.class)) {
                args[index++] = request;
                continue;
            }
            if (Objects.equals(parameter.getType(), KjjHttpResponse.class)) {
                args[index++] = response;
                continue;
            }
            if (Exception.class.isAssignableFrom(parameter.getType())) {
                args[index++] = exception;
                continue;
            }
            throw new UnsupportedOperationException("\u76ee\u524d\u6682\u4e0d\u652f\u6301\u5176\u4ed6\u989d\u5916\u7684\u53c2\u6570\u3002");
        }
        return args;
    }
}

