/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.autoconfig;

import cn.com.duiba.kjy.base.customweb.autoconfig.NettyAutoConfiguration;
import cn.com.duiba.kjy.base.customweb.sever.NettyServerConfigurationProperties;
import cn.com.duiba.kjy.base.customweb.web.bind.ArgsResolver;
import cn.com.duiba.kjy.base.customweb.web.bind.impl.MyHttpRequestResolver;
import cn.com.duiba.kjy.base.customweb.web.bind.impl.MyHttpResponseResolver;
import cn.com.duiba.kjy.base.customweb.web.bind.impl.PrimitiveParamResolver;
import cn.com.duiba.kjy.base.customweb.web.bind.impl.RequestBodyParamResolver;
import cn.com.duiba.kjy.base.customweb.web.bind.impl.RequestEntityResolver;
import cn.com.duiba.kjy.base.customweb.web.codec.convert.IdArrayConvert;
import cn.com.duiba.kjy.base.customweb.web.codec.convert.IdDecodeConvert;
import cn.com.duiba.kjy.base.customweb.web.codec.convert.IdListConvert;
import cn.com.duiba.kjy.base.customweb.web.codec.convert.IdSetConvert;
import cn.com.duiba.kjy.base.customweb.web.handler.response.impl.JacksonHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.response.impl.VoidHandler;
import cn.com.duiba.kjy.base.customweb.web.processor.parameter.impl.ParamResolverProcessor;
import cn.com.duiba.kjy.base.customweb.web.processor.parameter.impl.RequestParamAnnotationProcessor;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.web.format.WebConversionService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.geo.format.DistanceFormatter;
import org.springframework.data.geo.format.PointFormatter;
import org.springframework.format.Formatter;
import org.springframework.format.support.FormattingConversionService;

@Configuration
@AutoConfigureBefore(value={NettyAutoConfiguration.class})
@ConditionalOnBean(value={NettyServerConfigurationProperties.class})
public class ArgumentsResolverAutoConfig {
    @Bean
    public RequestEntityResolver requestEntityResolver() {
        return new RequestEntityResolver();
    }

    @Bean
    public RequestBodyParamResolver requestBodyParamResolver() {
        return new RequestBodyParamResolver();
    }

    @Bean
    public MyHttpRequestResolver myHttpRequestResolver() {
        return new MyHttpRequestResolver();
    }

    @Bean
    public MyHttpResponseResolver myHttpResponseResolver() {
        return new MyHttpResponseResolver();
    }

    @Bean
    public ParamResolverProcessor paramResolverProcessor(ObjectProvider<ArgsResolver> argsResolvers) {
        List<ArgsResolver> resolvers = argsResolvers.stream().sorted(OrderComparator.INSTANCE).collect(Collectors.toList());
        Collections.reverse(resolvers);
        return new ParamResolverProcessor(resolvers);
    }

    @Bean
    public RequestParamAnnotationProcessor requestParamAnnotationProcessor() {
        return new RequestParamAnnotationProcessor();
    }

    @Bean
    public PrimitiveParamResolver primitiveParamResolver() {
        return new PrimitiveParamResolver();
    }

    @Bean
    public FormattingConversionService conversionService() {
        WebConversionService conversionService = new WebConversionService(null);
        conversionService.addFormatter((Formatter)DistanceFormatter.INSTANCE);
        conversionService.addFormatter((Formatter)PointFormatter.INSTANCE);
        conversionService.addConverter((GenericConverter)new IdDecodeConvert());
        conversionService.addConverter((GenericConverter)new IdArrayConvert());
        conversionService.addConverter((GenericConverter)new IdListConvert());
        conversionService.addConverter((GenericConverter)new IdSetConvert());
        return conversionService;
    }

    @Bean
    public JacksonHandler jacksonHandler() {
        return new JacksonHandler();
    }

    @Bean
    public VoidHandler voidHandler() {
        return new VoidHandler();
    }
}

