/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilterChain;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingRegister;
import com.alibaba.fastjson.JSON;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.http.entity.ContentType;
import org.springframework.boot.actuate.beans.BeansEndpoint;

public class ActuateFilter
implements CustomFilter {
    private final BeansEndpoint beansEndpoint;
    @Resource
    private ControllerMappingRegister controllerMappingRegister;

    public ActuateFilter(BeansEndpoint beansEndpoint) {
        this.beansEndpoint = beansEndpoint;
    }

    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        String path;
        if (SpringEnvironmentUtils.isDevEnv()) {
            customFilterChain.filter(httpRequest, response);
            return;
        }
        switch (path = httpRequest.getUri().getPath()) {
            case "/beans": {
                response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
                if (Objects.nonNull(this.beansEndpoint)) {
                    response.write(JSON.toJSONString((Object)this.beansEndpoint.beans()));
                } else {
                    response.write("no auth!");
                }
                response.flushAndClose();
                return;
            }
            case "/mappings": {
                response.write(JSON.toJSONString(this.controllerMappingRegister.getHandlerList()));
                response.flushAndClose();
                return;
            }
        }
        customFilterChain.filter(httpRequest, response);
    }
}

