/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilter;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.StopWatch;

public class CustomFilterChain {
    public static final AtomicInteger count = new AtomicInteger(0);
    public static final AtomicLong time = new AtomicLong(0L);
    public static final AtomicLong beforeTime = new AtomicLong(0L);
    public static final AtomicLong afterTime = new AtomicLong(0L);
    private final List<CustomFilter> filterList;
    private int pos;
    private int size;
    private final DispatcherHandler dispatcherHandler;
    private StopWatch beforeStopWatch;
    private StopWatch afterStopWatch;

    public CustomFilterChain(List<CustomFilter> filterList, DispatcherHandler dispatcherHandler) {
        this.filterList = filterList;
        this.dispatcherHandler = dispatcherHandler;
        this.pos = 0;
        this.size = filterList.size();
        this.beforeStopWatch = new StopWatch();
        this.afterStopWatch = new StopWatch();
        this.beforeStopWatch.start();
    }

    public void filter(KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        if (CollectionUtils.isEmpty(this.filterList)) {
            this.dispatcherHandler.service(httpRequest, response);
        }
        if (this.pos < this.size) {
            CustomFilter customFilter = this.filterList.get(this.pos++);
            customFilter.doFilter(this, httpRequest, response);
        } else {
            this.beforeStopWatch.stop();
            beforeTime.addAndGet(this.beforeStopWatch.getTotalTimeNanos());
            this.dispatcherHandler.service(httpRequest, response);
            this.afterStopWatch.start();
            count.incrementAndGet();
        }
    }

    public void stopAfterWatch() {
        this.afterStopWatch.stop();
        afterTime.addAndGet(this.afterStopWatch.getTotalTimeNanos());
    }
}

