/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.kjy.base.customweb.util.PerfTestUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilterChain;
import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StopWatch;

public class KjjAccessLogFilter2
implements CustomFilter {
    private static final Logger log = LoggerFactory.getLogger(KjjAccessLogFilter2.class);
    private static final String DONT_WRITE_CURRENT_ACCESSLOG = "dont_write_current_accesslog";
    private static final Logger accessLog = LoggerFactory.getLogger((String)"duiba_access_log");
    private static final String EX_ATTRIBUTE_KEY = "_accesslog_ex";
    private static final String APP_ID_ATTRIBUTE_KEY = "_accesslog_app_id";
    private static final String CONSUMER_ID_ATTRIBUTE_KEY = "_accesslog_consumer_id";
    @Value(value="${spring.application.name}")
    private String appName;
    public static final AtomicInteger count = new AtomicInteger(0);
    public static final AtomicLong logTime = new AtomicLong(0L);
    public static final AtomicLong afterTime = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            customFilterChain.filter(httpRequest, response);
        }
        finally {
            StopWatch stopWatch1 = new StopWatch();
            stopWatch1.start();
            this.doAfter(httpRequest, response, System.currentTimeMillis() - start);
            stopWatch1.stop();
            long totalTimeNanos = stopWatch1.getTotalTimeNanos();
            afterTime.addAndGet(totalTimeNanos);
            count.incrementAndGet();
        }
    }

    protected void doAfter(KjjHttpRequest req, KjjHttpResponse resp, long cost) {
        try {
            boolean isPerfUrl = this.isPerfTestRequest(req);
            if (!isPerfUrl && this.needLog(req)) {
                this.processAccessLog(req, resp, cost);
            }
        }
        catch (Exception e) {
            log.error("AccessLogFilter process error, message=", (Throwable)e);
        }
    }

    private void processAccessLog(KjjHttpRequest req, KjjHttpResponse resp, long cost) throws Exception {
        String method = StringUtils.lowerCase((String)this.getMethod(req));
        if (!"get".equals(method) && !"post".equals(method)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("app_name", this.appName);
        map.put("url_host", this.getHeader(req, "host"));
        map.put("url_path", this.getRequestURI(req));
        map.put("url_query", this.getQueryString(req));
        map.put("http_method", this.getMethod(req));
        map.put("rc", this.getStatus(resp));
        map.put("rt", cost);
        map.put("mip", NetUtils.getLocalIp());
        this.putIfNotNull(map, "ex", this.getExPair(req));
        String callback = this.getParameter(req, "callback");
        if (!StringUtils.isBlank((CharSequence)callback)) {
            map.put("http_method", "POST");
        }
        Long consumerId = this.getConsumerId(req);
        Long appId = this.getAppId(req);
        this.putIfNotNull(map, "consumer_id", consumerId);
        this.putIfNotNull(map, "app_id", appId);
        this.putUa(req, map);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("time", sdf.format(new Date()));
        String referer = this.getHeader(req, "referer");
        this.putIfNotNull(map, "referer", referer);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        accessLog.info(JSON.toJSONString(map));
        stopWatch.stop();
        logTime.addAndGet(stopWatch.getTotalTimeNanos());
    }

    public void putExPair(KjjHttpRequest req, String key, Object value) {
        this.ensureSafeCall();
        HashMap<String, Object> map = (HashMap<String, Object>)this.getAttribute(req, EX_ATTRIBUTE_KEY);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.addAttribute(req, EX_ATTRIBUTE_KEY, map);
        }
        map.put(key, value);
    }

    private Map<String, Object> getExPair(KjjHttpRequest req) {
        return (Map)this.getAttribute(req, EX_ATTRIBUTE_KEY);
    }

    public void setConsumerId(KjjHttpRequest req, Long consumerId) {
        this.addAttribute(req, CONSUMER_ID_ATTRIBUTE_KEY, consumerId);
    }

    public void setAppId(KjjHttpRequest request, Long sellerId) {
        this.addAttribute(request, APP_ID_ATTRIBUTE_KEY, sellerId);
    }

    private Long getAppId(KjjHttpRequest req) {
        return (Long)this.getAttribute(req, APP_ID_ATTRIBUTE_KEY);
    }

    private Long getConsumerId(KjjHttpRequest req) {
        return (Long)this.getAttribute(req, CONSUMER_ID_ATTRIBUTE_KEY);
    }

    private void putUa(KjjHttpRequest req, Map<String, Object> map) {
        String ua = StringUtils.trimToEmpty((String)this.getHeader(req, "user-agent"));
        if (ua.length() > 500) {
            ua = ua.substring(0, 499);
        }
        if (!StringUtils.isEmpty((CharSequence)ua)) {
            map.put("user_agent", ua);
        }
    }

    private void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private boolean needLog(KjjHttpRequest req) {
        Boolean val = (Boolean)this.getAttribute(req, DONT_WRITE_CURRENT_ACCESSLOG);
        return val == null || val == false;
    }

    protected String getRequestURI(KjjHttpRequest req) {
        return req.getRequestURI();
    }

    protected String getMethod(KjjHttpRequest req) {
        return req.getMethod();
    }

    protected String getQueryString(KjjHttpRequest req) {
        return req.getQueryString();
    }

    protected String getHeader(KjjHttpRequest req, String key) {
        return req.getHeader(key);
    }

    protected String getIpAddr(KjjHttpRequest req) {
        return req.getIpAddr();
    }

    protected boolean isPerfTestRequest(KjjHttpRequest req) {
        return PerfTestUtil.isPerfTestRequest(req);
    }

    protected void addAttribute(KjjHttpRequest req, String key, Object value) {
        req.addAttribute(key, value);
    }

    protected Object getAttribute(KjjHttpRequest req, String key) {
        return req.getAttribute(key);
    }

    protected String getParameter(KjjHttpRequest req, String key) {
        return req.getParameter(key);
    }

    protected int getStatus(KjjHttpResponse resp) {
        return resp.getResponse().status().code();
    }

    protected void ensureSafeCall() {
        String threadName = StringUtils.defaultString((String)Thread.currentThread().getName());
        if (!threadName.startsWith("netty")) {
            log.error("can not use accessLogger out of netty work thread!");
        }
    }
}

