/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.service.datasource;

import cn.com.duiba.kjy.base.api.service.datasource.DbMovingDataSource;
import cn.com.duiba.kjy.base.api.service.datasource.MovingDataSourceConfiguration;
import cn.com.duiba.kjy.base.api.service.datasource.MovingDbProperties;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import com.dianping.cat.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnProperty(prefix="kjj.datasource.moving", name={"enable"}, havingValue="true")
public class DbMovingAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(DbMovingAutoConfig.class);

    @Bean
    public MovingDataSourceConfiguration dataSourceConfiguration() {
        return new MovingDataSourceConfiguration();
    }

    @Bean
    public static SpecifiedBeanPostProcessor<DataSource> dbMovingSpecifiedBeanPostProcessor() {
        return new SpecifiedBeanPostProcessor<DataSource>(){
            @Resource
            private ApplicationContext applicationContext;
            @Resource
            private MovingDataSourceConfiguration movingDataSourceConfiguration;
            @Resource
            private StringRedisTemplate stringRedisTemplate;
            private final Map<String, String> dataSourceConfig = new HashMap<String, String>();
            private final Map<String, String> redisKeyConfig = new HashMap<String, String>();

            @PostConstruct
            public void init() {
                Map<String, MovingDbProperties> db = this.movingDataSourceConfiguration.getDb();
                for (Map.Entry<String, MovingDbProperties> dbPropertiesEntry : db.entrySet()) {
                    String oldDataSource = dbPropertiesEntry.getKey();
                    MovingDbProperties newDbConfig = dbPropertiesEntry.getValue();
                    this.dataSourceConfig.put(oldDataSource, newDbConfig.getNewDataSource());
                    this.redisKeyConfig.put(oldDataSource, newDbConfig.getRedisKey());
                }
            }

            public int getOrder() {
                return Integer.MAX_VALUE;
            }

            public Class<DataSource> getBeanType() {
                return DataSource.class;
            }

            public DataSource postProcessBeforeInitialization(DataSource bean, String beanName) throws BeansException {
                return bean;
            }

            public DataSource postProcessAfterInitialization(DataSource bean, String beanName) throws BeansException {
                String movingDbNewBean = this.dataSourceConfig.get(beanName);
                if (StringUtils.isEmpty((String)movingDbNewBean)) {
                    return bean;
                }
                String redisKey = this.redisKeyConfig.get(beanName);
                DataSource newDbBean = (DataSource)this.applicationContext.getBean(movingDbNewBean, DataSource.class);
                DbMovingDataSource dbMovingDataSource = new DbMovingDataSource(bean, newDbBean, redisKey, this::getFlag);
                dbMovingDataSource.afterPropertiesSet();
                return dbMovingDataSource;
            }

            public String getFlag(String redisKey) {
                return (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
            }
        };
    }
}

