/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.service.datasource;

import cn.com.duiba.kjy.base.api.service.datasource.DbMovingDataSource;
import cn.com.duiba.kjy.base.api.service.datasource.MovingDataSourceConfiguration;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import com.dianping.cat.util.StringUtils;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="kjj.datasource.moving", name={"enable"}, havingValue="true")
public class DbMovingAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(DbMovingAutoConfig.class);

    @Bean
    public MovingDataSourceConfiguration dataSourceConfiguration() {
        return new MovingDataSourceConfiguration();
    }

    @Bean
    public static SpecifiedBeanPostProcessor<DataSource> dbMovingSpecifiedBeanPostProcessor() {
        return new SpecifiedBeanPostProcessor<DataSource>(){
            @Resource
            private ApplicationContext applicationContext;
            @Resource
            private MovingDataSourceConfiguration movingDataSourceConfiguration;

            public int getOrder() {
                return -1;
            }

            public Class<DataSource> getBeanType() {
                return DataSource.class;
            }

            public DataSource postProcessBeforeInitialization(DataSource bean, String beanName) throws BeansException {
                String movingDbNewBean = this.movingDataSourceConfiguration.getNewDataSource().get(beanName);
                if (StringUtils.isEmpty((String)movingDbNewBean)) {
                    return bean;
                }
                String redisKey = this.movingDataSourceConfiguration.getRedisKey().get(beanName);
                DataSource newDbBean = (DataSource)this.applicationContext.getBean(movingDbNewBean, DataSource.class);
                return new DbMovingDataSource(bean, newDbBean, redisKey);
            }

            public DataSource postProcessAfterInitialization(DataSource bean, String beanName) throws BeansException {
                return bean;
            }
        };
    }
}

