/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.service.datasource;

import cn.com.duiba.wolf.cache.RedisCacheClient;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DbMovingDataSource
extends AbstractRoutingDataSource {
    @Resource(name="redis")
    private RedisCacheClient redisCacheClient;
    private final DataSource oldDataSource;
    private final DataSource newDataSource;
    private final String redisKey;
    private static final String OLD_KEY = "old";
    private static final String NEW_KEY = "new";

    public DbMovingDataSource(DataSource oldDataSource, DataSource newDataSource, String redisKey) {
        this.oldDataSource = oldDataSource;
        this.newDataSource = newDataSource;
        this.redisKey = redisKey;
    }

    public void afterPropertiesSet() {
        HashMap<String, DataSource> targetDataSource = new HashMap<String, DataSource>();
        targetDataSource.put(OLD_KEY, this.oldDataSource);
        targetDataSource.put(NEW_KEY, this.newDataSource);
        this.setTargetDataSources(targetDataSource);
        this.setDefaultTargetDataSource(this.oldDataSource);
        super.afterPropertiesSet();
    }

    protected Object determineCurrentLookupKey() {
        Long flag = (Long)this.redisCacheClient.get(this.redisKey);
        if (Objects.nonNull(flag) && flag > 0L) {
            return NEW_KEY;
        }
        return OLD_KEY;
    }
}

