# readme
如果需要数据库迁移时，可选择使用此工具。

原理
-
- 利用springboot的dataSource动态路由类对旧的dataSource进行二次封装，内部包含新旧两个数据源
- 利用redis做实时同步。spring动态路由内部 每次从redis中获取数据库配置的最新值，根据该key的值选择使用新的或旧的数据源


步骤如下
 - 
 - 开启配置：  kjj.datasource.moving.enable=true(application.properties)
 - 配置数据源：将新的数据源配置到spring-datasource-XXX.xml中
 - 指向数据源：kjj.datasource.moving.db.${旧的dataSource}.newDataSource=${新的dataSource}(application.properties)
 - 配置redis开关：kjj.datasource.moving.db.${旧的dataSource}.redisKey=XXXXX
 - 发布系统
 - 调用url修改redis开关。curl 127.0.0.1:port/db/moving/on?key=${redisKey}
 - 删掉旧的dataSource，将新的dataSource的beanName改为旧的
 - 关闭配置： kjj.datasource.moving.enable=false(application.properties) 或者直接删除该属性
 - 重新发布系统 并清理掉redisKey的值（为后来人提供良好的环境）。

注意
-
- 此设计中利用了redis作为集群控制器，所以系统必须依赖redis.请使用jedis客户端，而不是redis客户端（lettuce客户端有延时加载问题，启动会报错）。
- redisKey的value为空时，默认为false。redis客户端使用的是redisCacheClient类。
- /db/moving/on?key=${redisKey} 切换
- /db/moving/off?key=${redisKey} 当出问题时，可选择再切回来
- /db/moving/list 查看当前服务的迁移配置，和当前状态。当redisValue=1时，表示切换过了。没有此参数时，表示还未切换
- 如果某个库迁移涉及多个系统时，请务必保证多系统的redisKey相同，且redis实例为同一个。切换时，任意选择一个发起请求即可

