package cn.com.duiba.kjy.base.customweb.sever;

import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionChain;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;

/**
 * @author dugq
 * @date 2021/3/26 3:52 下午
 */
@Slf4j
public class CustomNettyServer implements WebServer {
    private final ServerBootstrap nettyServer ;
    private final NettyServerConfigurationProperties nettyConfig;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workGroup;
    private final DispatcherHandler dispatcherHandler;
    private final ExceptionChain exceptionChain;

    public CustomNettyServer(NettyServerConfigurationProperties nettyConfig, EventLoopGroup bossGroup, EventLoopGroup workGroup, DispatcherHandler dispatcherHandler, ExceptionChain exceptionChain){
        this.dispatcherHandler = dispatcherHandler;
        nettyServer = new ServerBootstrap();
        this.nettyConfig = nettyConfig;
        this.bossGroup = bossGroup;
        this.workGroup = workGroup;
        this.exceptionChain =exceptionChain;
    }

    @Override
    public void start() throws WebServerException {
        nettyServer.group(this.bossGroup, this.workGroup)
                .channel(NioServerSocketChannel.class)
                .handler(new LoggingHandler(LogLevel.DEBUG))
                .option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)
                .option(ChannelOption.SO_RCVBUF, 32*1024)
                .childHandler(new ServerChannelInitializer(dispatcherHandler,exceptionChain))
                .childOption(ChannelOption.TCP_NODELAY, true)
                .childOption(ChannelOption.SO_KEEPALIVE, true)
                .childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        final ChannelFuture channelFuture1 = nettyServer.bind(this.nettyConfig.getPort()).addListener(channelFuture -> {
            if (channelFuture.isSuccess()) {
                log.info("服务端启动成功 port = {}", this.nettyConfig.getPort());
            } else {
                log.info("服务端启动失败 port = {}", this.nettyConfig.getPort());
            }
        });
        try {
            channelFuture1.sync();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() throws WebServerException {

    }

    @Override
    public int getPort() {
        return 0;
    }
}
