package cn.com.duiba.kjy.base.customweb.sever;

import cn.com.duiba.kjy.base.customweb.util.StopWatchUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionChain;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.entity.ContentType;
import org.springframework.util.StopWatch;

/**
 * @author dugq
 * @date 2020-08-10 17:35
 */
@Slf4j
public class KjjChannelInboundHandler extends SimpleChannelInboundHandler<FullHttpRequest> {

    private final DispatcherHandler dispatcherHandler;
    private final ExceptionChain exceptionChain;

    public KjjChannelInboundHandler(DispatcherHandler dispatcherHandler,ExceptionChain exceptionChain) {
        this.dispatcherHandler = dispatcherHandler;
        this.exceptionChain = exceptionChain;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest httpRequest) throws Exception {
        doReader(ctx, httpRequest);
    }

    private void doReader(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        StopWatch stopWatch = StopWatchUtil.getAndStart();
        KjjHttpRequest request = new KjjHttpRequest(ctx, httpRequest);
        KjjHttpResponse response = new KjjHttpResponse(ctx, httpRequest);
        try {
            dispatcherHandler.handler(request,response);
        }catch (Throwable e){
            exceptionChain.handlerException(request,response,e);
        }finally {
            try {
                if (request.isSync() && !response.isClosed()){
                    log.error("request where uri = {} is not closed right!", httpRequest.uri());
                    response.setContentType(ContentType.TEXT_PLAIN.getMimeType());
                    response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
                    response.write("NO RESPONSE");
                    response.flushAndClose();
                }
            }catch (Exception e){
                log.error("request disaster tolerance has error! this must be joker!",e);
            }
            StopWatchUtil.stop(StopWatchUtil.Key.TOTAL,request,stopWatch);
        }
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    /**
     * 通道关闭
     */
    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    /**
     * 通道可以使用
     */
    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    /**
     * web内部的所有异常应该在 {@link #channelRead0}中被完全处理掉。
     * 到达这里的应该是请求通道建立本身发生错误，如若不是，那么问题就大了
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("channel has exception = {}",ctx.channel(),cause);
        ctx.close();
    }
}
