package cn.com.duiba.kjy.base.customweb.web.handler;

import cn.com.duiba.kjy.base.customweb.exception.ResponseNotClosedException;
import cn.com.duiba.kjy.base.customweb.exception.ResponseStatusException;
import cn.com.duiba.kjy.base.customweb.util.StopWatchUtil;
import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.factory.FilterChainFactory;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilterChain;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.HandlerExecutionChain;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.RequestMappingsRegister;
import cn.com.duiba.kjy.base.customweb.web.interceptor.KjjInterceptor;
import io.netty.handler.codec.http.HttpResponseStatus;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StopWatch;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/25 10:56 上午
 */
@Slf4j
public class DispatcherHandler {

    private final List<RequestMappingsRegister> requestMappingsRegisterList;
    private final List<KjjInterceptor> interceptorList;
    @Resource
    private FilterChainFactory filterChainFactory;

    public DispatcherHandler(List<RequestMappingsRegister> requestMappingsRegisterList, List<KjjInterceptor> interceptors) {
        this.requestMappingsRegisterList = requestMappingsRegisterList;
        this.interceptorList = interceptors;
    }

    public void handler(KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        httpRequest.setResponse(response);
        CustomFilterChain customFilterChain = filterChainFactory.getInstance(this);
        customFilterChain.filter(httpRequest,response);
    }

    /**
     * 目前只支持 requestMappingAdaptor 后续需要适配 resourceMappingAdaptor
     */
    public void service(KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        final StopWatch handle = StopWatchUtil.getAndStart();
        final HandlerExecutionChain mappedHandler = getRequestMapping(httpRequest);
        if (Objects.isNull(mappedHandler)) {
            throw new ResponseStatusException(HttpResponseStatus.NOT_FOUND);
        }
        try {
            final RequestHandlerMappingAdaptor adaptor = mappedHandler.getAdaptor();
            final boolean stop = mappedHandler.applyPreHandle(httpRequest, response, mappedHandler.getHandler());
            if (stop) {
                if (!response.isClosed()) {
                    log.error("response is not closed in interceptor.uri = {}", httpRequest.uri());
                    throw new ResponseNotClosedException();
                }
                return;
            }
            final StopWatch ctrl = StopWatchUtil.getAndStart();
            Object result = adaptor.handler(mappedHandler.getHandler(), httpRequest, response);
            StopWatchUtil.stop(StopWatchUtil.Key.CTRL,httpRequest,ctrl);

            mappedHandler.applyPostHandle(httpRequest, response, mappedHandler.getHandler(), result);

            adaptor.handlerResult(result, httpRequest, response, mappedHandler.getHandler());

            mappedHandler.afterCompletion(httpRequest, response,null);
        }catch (Exception e){
            mappedHandler.afterCompletion(httpRequest, response,e);
            throw e;
        }finally {
            StopWatchUtil.stop(StopWatchUtil.Key.HANDLE,httpRequest,handle);
        }
    }


    public HandlerExecutionChain getRequestMapping(KjjHttpRequest httpRequest){
        for (RequestMappingsRegister requestMappingsRegister : requestMappingsRegisterList) {
            final Object handler = requestMappingsRegister.getHandler(httpRequest);
            if (Objects.nonNull(handler)){
                return new HandlerExecutionChain(interceptorList, requestMappingsRegister,handler);
            }
        }
        return null;
    }




}
