/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.service.datasource;

import cn.com.duiba.kjy.base.api.service.datasource.MovingDataSourceConfiguration;
import cn.com.duiba.kjy.base.api.service.datasource.MovingDbProperties;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;

public class DbMovingSwitchFilter
implements Filter {
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private MovingDataSourceConfiguration movingDataSourceConfiguration;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            String requestURI = httpServletRequest.getRequestURI();
            if (StringUtils.equals((String)requestURI, (String)"/db/moving/on")) {
                String key = httpServletRequest.getParameter("key");
                if (StringUtils.isBlank((String)key)) {
                    this.writeResponseJson(response, "NO redis KEY in request Param.");
                    return;
                }
                this.stringRedisTemplate.opsForValue().set((Object)key, (Object)"1", 1L, TimeUnit.DAYS);
                this.writeResponseJson(response, "on success");
                return;
            }
            if (StringUtils.equals((String)requestURI, (String)"/db/moving/off")) {
                String key = httpServletRequest.getParameter("key");
                if (StringUtils.isBlank((String)key)) {
                    this.writeResponseJson(response, "NO redis KEY in request Param.");
                    return;
                }
                this.stringRedisTemplate.delete((Object)key);
                this.writeResponseJson(response, "off success");
                return;
            }
            if (StringUtils.equals((String)requestURI, (String)"/db/moving/list")) {
                Map<String, MovingDbProperties> db = this.movingDataSourceConfiguration.getDb();
                LinkedList result = new LinkedList();
                for (Map.Entry<String, MovingDbProperties> dbPropertiesEntry : db.entrySet()) {
                    String oldDb = dbPropertiesEntry.getKey();
                    String newDb = dbPropertiesEntry.getValue().getNewDataSource();
                    String redisKey = dbPropertiesEntry.getValue().getRedisKey();
                    String redisValue = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("oldDb", oldDb);
                    map.put("newDb", newDb);
                    map.put("redisKey", redisKey);
                    map.put("redisValue", redisValue);
                    result.add(map);
                }
                this.writeResponseJson(response, result);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void writeResponseJson(ServletResponse response, Object message) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        ((HttpServletResponse)response).setStatus(200);
        response.getWriter().println(JSON.toJSONString((Object)message));
        response.getWriter().flush();
        response.getWriter().close();
    }
}

