/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilterChain;
import cn.com.duibaboot.ext.autoconfigure.web.ServerStatusHolder;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Objects;

public class MonitorFilter
implements CustomFilter {
    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        String uri = httpRequest.uri();
        if (Objects.equals(uri, "/monitor/check")) {
            if (!ServerStatusHolder.isInService()) {
                response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
            }
            response.write(ServerStatusHolder.isInService() ? "OK" : "INVALID");
            response.flushAndClose();
        } else if (Objects.equals(uri, "/monitor/stop")) {
            if (!this.isLocal(httpRequest)) {
                response.write("NO PERMISSION");
                response.flushAndClose();
                return;
            }
            ServerStatusHolder.setInService((boolean)false);
            response.write("OK");
            response.flushAndClose();
        } else if (Objects.equals(uri, "/monitor/start")) {
            if (!this.isLocal(httpRequest)) {
                response.write("NO PERMISSION");
                response.flushAndClose();
                return;
            }
            ServerStatusHolder.setInService((boolean)true);
            response.write("OK");
            response.flushAndClose();
        } else {
            customFilterChain.filter(httpRequest, response);
        }
    }

    private boolean isLocal(KjjHttpRequest httpRequest) {
        return httpRequest.getIpAddr().equals("127.0.0.1") && httpRequest.getIpAddr().equals("0:0:0:0");
    }
}

