/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.reactive.convert;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.kjy.base.reactive.convert.IdDecode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdDecodeBean {
    private static final Logger log = LoggerFactory.getLogger(IdDecodeBean.class);

    protected Long decodeId(IdDecode parameterAnnotation, String value, Class<?> parameterType, String filedName) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            return IdMakeUtil.decodingId(value);
        }
        catch (Exception e) {
            log.error("id ILLEGAL1", (Throwable)e);
            return null;
        }
    }

    protected boolean isPrimitiveOrString(Class<?> parameterType) {
        return parameterType.isPrimitive() || Number.class.isAssignableFrom(parameterType) || parameterType.equals(String.class);
    }

    protected Boolean isArray(Class<?> parameterType) {
        return parameterType.isArray();
    }

    protected Boolean isCollection(Class<?> parameterType) {
        return List.class.isAssignableFrom(parameterType) || Set.class.isAssignableFrom(parameterType);
    }

    protected List<Field> getAllFields(Class clazz) {
        if (Objects.isNull(clazz) || clazz.isInterface()) {
            return Collections.emptyList();
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != Object.class) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    protected Boolean isMap(Class<?> parameterType) {
        return Map.class.isAssignableFrom(parameterType);
    }
}

