/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.autoconfig;

import cn.com.duiba.kjy.base.customweb.sever.CustomNettyServer;
import cn.com.duiba.kjy.base.customweb.sever.NettyServerConfigurationProperties;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionChain;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={NettyServerConfigurationProperties.class})
@ConditionalOnMissingBean(value={WebServer.class})
public class NettyAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(NettyAutoConfiguration.class);
    @Resource
    private NettyServerConfigurationProperties nettyServerConfigurationProperties;
    @Resource
    private DispatcherHandler dispatcherHandler;
    @Resource
    private NettyServerConfigurationProperties nettyConfig;
    @Resource
    private ExceptionChain exceptionChain;

    @Bean
    public CustomNettyServer getWebServer() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(this.nettyServerConfigurationProperties.getBossThread(), new ThreadFactory(){
            private final AtomicInteger index = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "netty-BOSS_" + this.index.incrementAndGet());
            }
        });
        NioEventLoopGroup workGroup = new NioEventLoopGroup(this.nettyServerConfigurationProperties.getWorkThread(), new ThreadFactory(){
            private final AtomicInteger index = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "netty-WORK_" + this.index.incrementAndGet());
            }
        });
        CustomNettyServer customNettyServer = new CustomNettyServer(this.nettyConfig, (EventLoopGroup)bossGroup, (EventLoopGroup)workGroup, this.dispatcherHandler, this.exceptionChain);
        customNettyServer.start();
        return customNettyServer;
    }
}

