/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.bean;

import cn.com.duiba.kjy.base.customweb.util.UrlHelper;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjContext;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class KjjHttpRequest {
    private static final Logger log = LoggerFactory.getLogger(KjjHttpRequest.class);
    private static final String UNKNOWN = "unknown";
    private final FullHttpRequest fullHttpRequest;
    private final URI uri;
    private final MultiValueMap<String, String> paramMap = new LinkedMultiValueMap();
    private byte[] requestBody;
    private ContentType contentType;
    private MediaType mediaType;
    private boolean sync = true;
    private KjjHttpResponse response;
    private final ChannelHandlerContext context;
    private InetSocketAddress remoteAddress;
    private List<Cookie> cookies;
    private final Map<String, Object> attribute = new HashMap<String, Object>();
    private String remoteIp;

    public KjjHttpRequest(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest) {
        this.context = ctx;
        this.fullHttpRequest = fullHttpRequest;
        this.uri = this.getUri(fullHttpRequest);
        this.readyUri();
        this.readyBody();
        this.readyCookie();
        this.readyRemoteAddress();
    }

    private void readyCookie() {
        String cookieString = this.getHeader(HttpHeaderNames.COOKIE.toString());
        if (StringUtils.isBlank((String)cookieString)) {
            this.cookies = Collections.emptyList();
            return;
        }
        this.cookies = ServerCookieDecoder.STRICT.decodeAll(cookieString);
    }

    private void readyRemoteAddress() {
        SocketAddress socketAddress = this.context.channel().remoteAddress();
        InetSocketAddress remoteAddress = Objects.nonNull(socketAddress) && socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        this.remoteAddress = remoteAddress;
    }

    private void readyUri() {
        if (Objects.nonNull(this.uri)) {
            String query = this.uri.getQuery();
            this.extractUrlParams(query);
        }
    }

    public HttpMethod method() {
        return this.fullHttpRequest.method();
    }

    public HttpHeaders headers() {
        return this.fullHttpRequest.headers();
    }

    public ByteBuf content() {
        return this.fullHttpRequest.content();
    }

    public String uri() {
        return this.fullHttpRequest.uri();
    }

    private void extractUrlParams(String paramsStr) {
        if (StringUtils.isBlank((String)paramsStr)) {
            return;
        }
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean pos = false;
        for (char aChar : paramsStr.toCharArray()) {
            if (aChar == '=') {
                pos = true;
                continue;
            }
            if (aChar == '&') {
                pos = false;
                this.addParameter(key.toString(), value.toString());
                key.delete(0, key.length());
                value.delete(0, value.length());
                continue;
            }
            if (!pos) {
                key.append(aChar);
                continue;
            }
            value.append(aChar);
        }
        this.addParameter(key.toString(), value.toString());
    }

    private void readyBody() {
        ByteBuf content = this.fullHttpRequest.content();
        if (content.isReadable()) {
            this.requestBody = new byte[content.readableBytes()];
            content.readBytes(this.requestBody);
        }
    }

    private void addParameter(String key, String value) {
        if (StringUtils.isNotBlank((String)key)) {
            this.paramMap.add((Object)key, (Object)value);
        }
    }

    @Nullable
    private URI getUri(FullHttpRequest fullHttpRequest) {
        return UrlHelper.decodeAndCleanUriString(fullHttpRequest);
    }

    public ContentType getContentType() {
        if (Objects.nonNull(this.contentType)) {
            return this.contentType;
        }
        this.contentType = ContentType.parse((String)this.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
        return this.contentType;
    }

    public MediaType getMediaType() {
        if (Objects.nonNull(this.mediaType)) {
            return this.mediaType;
        }
        this.mediaType = MediaType.parseMediaType((String)this.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
        return this.mediaType;
    }

    public KjjContext startAsync() {
        this.sync = false;
        return new KjjContext(this, this.response);
    }

    public String getRequestURI() {
        return this.uri.getPath();
    }

    public String getMethod() {
        return this.fullHttpRequest.method().name();
    }

    public String getQueryString() {
        return this.uri.getQuery();
    }

    public String getHeader(String key) {
        return this.headers().get(key);
    }

    public String getIpAddr() {
        if (StringUtils.isBlank((String)this.remoteIp)) {
            this.remoteIp = this.getIpAddrInternal();
            return this.remoteIp;
        }
        return this.remoteIp;
    }

    private String getIpAddrInternal() {
        String ipAddrFromHeader = this.getIpAddrFromHeader();
        if (StringUtils.isNotBlank((String)ipAddrFromHeader)) {
            return ipAddrFromHeader;
        }
        if (Objects.isNull(this.remoteAddress)) {
            return null;
        }
        return this.remoteAddress.getAddress().getHostAddress();
    }

    public void addAttribute(String name, Object object) {
        this.attribute.put(name, object);
    }

    public String getParameter(String parameterName) {
        return (String)this.paramMap.getFirst((Object)parameterName);
    }

    public Object getAttribute(String key) {
        return this.attribute.get(key);
    }

    public String toString() {
        return "KjjHttpRequest{, uri=" + this.uri + ", paramMap=" + this.paramMap + ", contentType=" + this.contentType + ", mediaType=" + this.mediaType + ", sync=" + this.sync + ", remoteAddress=" + this.getIpAddr() + ", cookies=" + this.cookies + ", attribute=" + this.attribute + '}';
    }

    public String getIpAddrFromHeader() {
        String[] ips;
        int size;
        String ip = this.headers().get("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[0].trim();
        }
        if (KjjHttpRequest.isInvalidIp(ip)) {
            ip = this.headers().get("X-Real-IP");
        }
        if (KjjHttpRequest.isInvalidIp(ip)) {
            ip = this.headers().get("Proxy-Client-IP");
        }
        if (KjjHttpRequest.isInvalidIp(ip)) {
            ip = this.headers().get("WL-Proxy-Client-IP");
        }
        if (KjjHttpRequest.isInvalidIp(ip)) {
            ip = this.headers().get("Cdn-Src-Ip");
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    private static boolean isInvalidIp(String ip) {
        return ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip);
    }

    public FullHttpRequest getFullHttpRequest() {
        return this.fullHttpRequest;
    }

    public URI getUri() {
        return this.uri;
    }

    public MultiValueMap<String, String> getParamMap() {
        return this.paramMap;
    }

    public byte[] getRequestBody() {
        return this.requestBody;
    }

    public boolean isSync() {
        return this.sync;
    }

    public KjjHttpResponse getResponse() {
        return this.response;
    }

    public ChannelHandlerContext getContext() {
        return this.context;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Map<String, Object> getAttribute() {
        return this.attribute;
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public void setRequestBody(byte[] requestBody) {
        this.requestBody = requestBody;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public void setResponse(KjjHttpResponse response) {
        this.response = response;
    }

    public void setRemoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public void setRemoteIp(String remoteIp) {
        this.remoteIp = remoteIp;
    }
}

