/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.bind.impl;

import cn.com.duiba.kjy.base.customweb.util.ParamReflectUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.bind.ArgsResolver;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.RequestBody;

@Order(value=-50)
public class RequestBodyParamResolver
implements ArgsResolver {
    private static final Logger log = LoggerFactory.getLogger(RequestBodyParamResolver.class);
    @Resource
    private ObjectMapper objectMapper;
    @Resource
    private Validator validator;

    @Override
    public boolean canRead(Parameter parameter, Class<?> handlerMappingClass, Method handlerMappingMethod) {
        return parameter.isAnnotationPresent(RequestBody.class) && !ParamReflectUtil.isPrimitive(parameter.getType()) && this.objectMapper.canDeserialize(this.objectMapper.getTypeFactory().constructType(parameter.getType()));
    }

    @Override
    public Object doResolver(ParameterBean parameterBean, KjjHttpRequest httpRequest, KjjHttpResponse response) {
        Object param;
        try {
            param = Objects.equals(httpRequest.getContentType().getMimeType(), ContentType.APPLICATION_JSON.getMimeType()) ? this.objectMapper.readValue(httpRequest.getRequestBody(), parameterBean.getJavaType()) : this.downgradeGetEmptyEntity(parameterBean);
        }
        catch (Exception e) {
            log.error("read json from netty request uri={} has error!", (Object)httpRequest.uri(), (Object)e);
            param = this.downgradeGetEmptyEntity(parameterBean);
        }
        Set validate = this.validator.validate(param, new Class[0]);
        if (!CollectionUtils.isEmpty((Collection)validate)) {
            throw new ConstraintViolationException(validate);
        }
        return param;
    }

    @Override
    public void prepareResolver(ParameterBean parameterBean, Class<?> handlerMappingClass, Method handlerMappingMethod) {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(parameterBean.getType());
        if (Objects.isNull(javaType)) {
            throw new RuntimeException("can not reflect param for this type :" + parameterBean.getType().getName());
        }
        parameterBean.setJavaType(javaType);
    }

    @Nullable
    private Object downgradeGetEmptyEntity(ParameterBean parameterBean) {
        try {
            return parameterBean.getType().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("there is no public and no args construct in class {}", (Object)parameterBean.getType().getName());
            return null;
        }
    }
}

