/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.kjj.oss.template;

import cn.com.duibaboot.kjj.oss.template.OssTemplate;
import cn.com.duibaboot.kjj.oss.template.operation.MultipartTask;
import cn.com.duibaboot.kjj.oss.template.operation.MultipartTaskImpl;
import cn.com.duibaboot.kjj.oss.template.support.MultiUploadSupport;
import cn.com.duibaboot.kjj.oss.template.util.OssUtils;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOssTemplate
implements OssTemplate {
    private static final Logger log = LoggerFactory.getLogger(AbstractOssTemplate.class);
    private OSSClient ossClient;
    private String bucketName;
    @Resource
    private ExecutorService ossExecutorService;

    @Override
    public MultipartTask createMultipartTask() {
        return new MultipartTaskImpl(this);
    }

    @Override
    public String simpleMultipartUpload(InputStream inputStream, String objectName, ObjectMetadata meta) {
        MultipartTask multipartTask = this.createMultipartTask();
        try {
            boolean result = MultiUploadSupport.simpleMultipartUpload(multipartTask, inputStream, objectName, meta);
            if (result) {
                this.getUrl(objectName);
            }
            return null;
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20oss\u53d1\u751f\u9519\u8bef\uff0c\u8f93\u5165\u6d41\u8bfb\u53d6\u5931\u8d25 objectName={}", (Object)objectName, (Object)e);
            return null;
        }
    }

    @Override
    public String uploadStream(InputStream inputStream, String objectName, ObjectMetadata meta) {
        OssUtils.validatorObjectName(objectName);
        PutObjectResult result = this.ossClient.putObject(this.bucketName, objectName, inputStream, meta);
        if (OssUtils.successful(result)) {
            return this.getUrl(objectName);
        }
        log.error("\u4e0a\u4f20oss\u53d1\u751f\u9519\u8bef.object name = {} msg = {}", (Object)objectName, (Object)OssUtils.getErrorMessage(result));
        return null;
    }

    @Override
    public String uploadString(String content, String objectName, ObjectMetadata meta) {
        if (StringUtils.isBlank((String)content)) {
            log.error("\u4e0a\u4f20oss\u53d1\u751f\u9519\u8bef:\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a.object name = {}", (Object)objectName);
            return null;
        }
        byte[] bytes = content.getBytes();
        return this.uploadStream(new ByteArrayInputStream(bytes), objectName, meta);
    }

    protected abstract String getUrl(String var1);

    public OSSClient getOssClient() {
        return this.ossClient;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public ExecutorService getOssExecutorService() {
        return this.ossExecutorService;
    }

    public void setOssClient(OSSClient ossClient) {
        this.ossClient = ossClient;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setOssExecutorService(ExecutorService ossExecutorService) {
        this.ossExecutorService = ossExecutorService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractOssTemplate)) {
            return false;
        }
        AbstractOssTemplate other = (AbstractOssTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OSSClient this$ossClient = this.getOssClient();
        OSSClient other$ossClient = other.getOssClient();
        if (this$ossClient == null ? other$ossClient != null : !this$ossClient.equals(other$ossClient)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        ExecutorService this$ossExecutorService = this.getOssExecutorService();
        ExecutorService other$ossExecutorService = other.getOssExecutorService();
        return !(this$ossExecutorService == null ? other$ossExecutorService != null : !this$ossExecutorService.equals(other$ossExecutorService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractOssTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OSSClient $ossClient = this.getOssClient();
        result = result * 59 + ($ossClient == null ? 43 : $ossClient.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        ExecutorService $ossExecutorService = this.getOssExecutorService();
        result = result * 59 + ($ossExecutorService == null ? 43 : $ossExecutorService.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractOssTemplate(ossClient=" + this.getOssClient() + ", bucketName=" + this.getBucketName() + ", ossExecutorService=" + this.getOssExecutorService() + ")";
    }
}

