/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.kjj.oss.template.operation;

import cn.com.duibaboot.kjj.oss.template.AbstractOssTemplate;
import cn.com.duibaboot.kjj.oss.template.operation.MultipartTask;
import cn.com.duibaboot.kjj.oss.template.util.OssUtils;
import com.aliyun.oss.model.AbortMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.StorageClass;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartTaskImpl
implements MultipartTask {
    private static final Logger log = LoggerFactory.getLogger(MultipartTaskImpl.class);
    private final AbstractOssTemplate ossTemplate;
    private String key;
    private String uploadId;
    private volatile boolean closed;
    private final List<PartETag> partETagList = new LinkedList<PartETag>();
    private volatile boolean created;

    public MultipartTaskImpl(AbstractOssTemplate ossTemplate) {
        this.ossTemplate = ossTemplate;
    }

    @Override
    public boolean startMultipartPartUpload(String objectName, ObjectMetadata objectMetadata) {
        OssUtils.validatorObjectName(objectName);
        if (this.created || this.closed) {
            log.error("\u5206\u7247\u4e0a\u4f20\u4efb\u52a1\u4e0d\u53ef\u91cd\u590d\u4f7f\u7528\u3002objectName={}", (Object)this.key);
            return false;
        }
        this.created = true;
        this.key = objectName;
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.ossTemplate.getBucketName(), objectName);
        objectMetadata.setHeader("x-oss-storage-class", (Object)StorageClass.Standard.toString());
        request.setObjectMetadata(objectMetadata);
        try {
            InitiateMultipartUploadResult result = this.ossTemplate.getOssClient().initiateMultipartUpload(request);
            if (!result.getResponse().isSuccessful()) {
                log.error("\u521d\u59cb\u5316\u5206\u7247\u4e0a\u4f20\u5931\u8d25\u3002objectName={} message = {}", (Object)objectName, (Object)result.getResponse().getErrorResponseAsString());
                this.created = false;
                return false;
            }
            if (StringUtils.isBlank((String)result.getUploadId())) {
                log.error("\u521d\u59cb\u5316\u5206\u7247\u4e0a\u4f20\u5931\u8d25\u3002\u672a\u77e5\u9519\u8bef\uff1a\u3010uploadId\u3011when \u3010init oss multipart operation\u3011 is null! objectName={}", (Object)objectName);
                this.created = false;
                return false;
            }
            this.uploadId = result.getUploadId();
            this.created = true;
            return true;
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u5206\u7247\u4e0a\u4f20\u5931\u8d25\u3002objectName={}", (Object)objectName, (Object)e);
            this.created = false;
            return false;
        }
    }

    @Override
    public boolean startContinuePartUpload(String uploadId, String objectName) {
        OssUtils.validatorObjectName(objectName);
        if (this.created || this.closed) {
            log.error("\u5206\u7247\u4e0a\u4f20\u4efb\u52a1\u4e0d\u53ef\u91cd\u590d\u4f7f\u7528\u3002objectName={}", (Object)this.key);
            return false;
        }
        this.created = true;
        this.uploadId = uploadId;
        this.key = objectName;
        return true;
    }

    @Override
    public boolean multipartPartUpload(InputStream inputStream, Long partSize, int partNumber) {
        if (partNumber < 1 || partNumber > 10000) {
            log.error("\u5206\u7247\u4e0b\u6807\u8d85\u51fa\u8303\u56f4\u3002\u30101\uff5e10000\u3011\u5f53\u524d\uff1a{} objectName={} uploadId={}", new Object[]{partNumber, this.key, this.uploadId});
            return false;
        }
        this.validator();
        UploadPartRequest uploadPartRequest = new UploadPartRequest();
        uploadPartRequest.setBucketName(this.ossTemplate.getBucketName());
        uploadPartRequest.setKey(this.key);
        uploadPartRequest.setUploadId(this.uploadId);
        uploadPartRequest.setInputStream(inputStream);
        uploadPartRequest.setPartSize(partSize.longValue());
        uploadPartRequest.setPartNumber(partNumber);
        try {
            UploadPartResult uploadPartResult = this.ossTemplate.getOssClient().uploadPart(uploadPartRequest);
            if (!OssUtils.successful(uploadPartResult)) {
                log.error("oss\u5206\u7247\u4e0a\u4f20\u5931\u8d25\u3002objectName={} uploadId={} msg={}", new Object[]{this.key, this.uploadId, OssUtils.getErrorMessage(uploadPartResult)});
                return false;
            }
            this.addPartTag(uploadPartResult.getPartETag());
            return true;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20oss\u5206\u7247\u5931\u8d25 objectName={}", (Object)this.key, (Object)e);
            return false;
        }
    }

    private void validator() {
        if (this.closed) {
            throw new UnsupportedOperationException("\u5206\u7247\u4e0a\u4f20\u4efb\u52a1\u4e0d\u53ef\u91cd\u590d\u4f7f\u7528\u3002");
        }
        if (!this.created) {
            throw new UnsupportedOperationException("\u5206\u7247\u4efb\u52a1\u672a\u521d\u59cb\u5316");
        }
    }

    @Override
    public List<PartETag> getSuccessfulUploadPart() {
        return this.partETagList;
    }

    private synchronized void addPartTag(PartETag eTag) {
        this.partETagList.add(eTag);
    }

    @Override
    public boolean multipartUpload() {
        this.validator();
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(this.ossTemplate.getBucketName(), this.key, this.uploadId, this.partETagList);
        try {
            CompleteMultipartUploadResult result = this.ossTemplate.getOssClient().completeMultipartUpload(completeMultipartUploadRequest);
            if (!OssUtils.successful(result)) {
                log.error("oss\u5206\u7247\u4e0a\u4f20\u5408\u6210\u5931\u8d25\u3002objectName={} uploadId={} msg={}", new Object[]{this.key, this.uploadId, OssUtils.getErrorMessage(result)});
                return false;
            }
            this.closed = true;
            return true;
        }
        catch (Exception e) {
            log.error("oss\u5206\u7247\u4e0a\u4f20\u5408\u6210\u5931\u8d25\u3002objectName={} uploadId={}", new Object[]{this.key, this.uploadId, e});
            return false;
        }
    }

    @Override
    public void cancel() {
        if (!this.created && StringUtils.isBlank((String)this.uploadId)) {
            this.closed = true;
            return;
        }
        try {
            AbortMultipartUploadRequest request = new AbortMultipartUploadRequest(this.ossTemplate.getBucketName(), this.key, this.uploadId);
            this.ossTemplate.getOssClient().abortMultipartUpload(request);
            this.closed = true;
        }
        catch (Exception e) {
            log.error("oss\u53d6\u6d88\u5206\u7247\u4e0a\u4f20\u5931\u8d25\u3002objectName={} uploadId={}", (Object)this.key, (Object)this.uploadId);
        }
    }
}

