package cn.com.duiba.kjy.base.customweb.web.codec.convert;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.kjy.base.customweb.web.codec.IdDecode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.util.ObjectUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author dugq
 * @date 2021/3/29 10:59 上午
 */
@Slf4j
public class IdListConvert  implements ConditionalGenericConverter {

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return targetType.hasAnnotation(IdDecode.class);
    }

    @Override
    public Set<ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new ConvertiblePair(Object[].class, List.class));
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (Objects.isNull(source)){
            return null;
        }
        if (!source.getClass().isArray()){
            log.error("can not convert target={} to Long[]",source);
            return null;
        }
        try {
            List<Object> sourceList = Arrays.asList(ObjectUtils.toObjectArray(source));
            return sourceList.stream().map(s-> IdMakeUtil.decodingId(s.toString())).collect(Collectors.toList());
        }catch (Exception e){
            log.error("can not convert target={} to Long[]",source,e);
            return null;
        }
    }
}
