package cn.com.duiba.kjy.base.reactive.adaptor;

import cn.com.duiba.kjy.base.reactive.interceptor.ReactiveInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

import javax.annotation.Resource;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/18 10:02 上午
 */
@Slf4j
public class CustomRequestMappingHandlerAdapter extends RequestMappingHandlerAdapter {
    @Resource
    private List<ReactiveInterceptor> interceptorList;

    @Override
    public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
        HandlerMethod handlerMethod = (HandlerMethod) handler;
        try {
            Object result = doBefore(exchange, handlerMethod);
            if (Objects.nonNull(result)) {
                return Mono.just(new HandlerResult(handlerMethod, result,HANDLER_FUNCTION_RETURN_TYPE));
            }
            return super.handle(exchange, handler);
        }finally {
            doAfter(exchange, handlerMethod);
        }

    }

    @Nullable
    private Object doBefore(ServerWebExchange exchange, HandlerMethod handlerMethod) {
        if (CollectionUtils.isNotEmpty(interceptorList)){
            for (ReactiveInterceptor interceptor : interceptorList){
                final Object result = interceptor.preHandle(exchange, handlerMethod);
                if (Objects.nonNull(result)){
                    return result;
                }
            }
        }
        return null;
    }

    private void doAfter(ServerWebExchange exchange, HandlerMethod handlerMethod) {
        if (CollectionUtils.isNotEmpty(interceptorList)){
            for (ReactiveInterceptor interceptor : interceptorList){
                try {
                    interceptor.afterHandle(exchange, handlerMethod);
                }catch (Throwable e){
                    log.error("do after  handle in interceptor has error!",e);
                }
            }
        }
    }

    public static final MethodParameter HANDLER_FUNCTION_RETURN_TYPE;

    static {
        try {
            final Method handle = CustomRequestMappingHandlerAdapter.class.getMethod("handle", Object.class);
            HANDLER_FUNCTION_RETURN_TYPE = new MethodParameter(handle, -1);
        } catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    @ResponseBody
    public Object handle(Object result){
        return result;
    }
}
