/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.util.StopWatchUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilter;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.StopWatch;

public class CustomFilterChain {
    private final List<CustomFilter> filterList;
    private int pos;
    private int size;
    private final DispatcherHandler dispatcherHandler;
    private StopWatch stopWatch;

    public CustomFilterChain(List<CustomFilter> filterList, DispatcherHandler dispatcherHandler) {
        this.filterList = filterList;
        this.dispatcherHandler = dispatcherHandler;
        this.pos = 0;
        this.size = filterList.size();
        this.stopWatch = StopWatchUtil.getAndStart();
    }

    public void filter(KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        if (CollectionUtils.isEmpty(this.filterList)) {
            this.dispatcherHandler.service(httpRequest, response);
        }
        if (this.pos < this.size) {
            CustomFilter customFilter = this.filterList.get(this.pos++);
            customFilter.doFilter(this, httpRequest, response);
        } else {
            StopWatchUtil.stop(StopWatchUtil.Key.FILTER, httpRequest, this.stopWatch);
            this.dispatcherHandler.service(httpRequest, response);
        }
    }
}

