/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.reactive.config;

import cn.com.duiba.kjy.base.reactive.adaptor.CustomRequestMappingHandlerAdapter;
import cn.com.duiba.kjy.base.reactive.config.ReactiveWebConfig;
import cn.com.duiba.kjy.base.reactive.convert.HttpReader;
import cn.com.duiba.kjy.base.reactive.convert.IdArgumentResolver;
import cn.com.duiba.kjy.base.reactive.fitler.MonitorWebFilter;
import cn.com.duiba.kjy.base.reactive.interceptor.ReactiveInterceptor;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.web.mvc.CustomHttpMessageConverters;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxRegistrations;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@Configuration
public class ReactiveAutoConfiguration {
    @ConditionalOnMissingBean(value={WebFluxConfigurer.class})
    @Bean
    public ReactiveWebConfig reactiveWebConfig() {
        return new ReactiveWebConfig();
    }

    @Bean
    @Order(value=-2147483648)
    public IdArgumentResolver getIdArgumentResolver() {
        return new IdArgumentResolver();
    }

    @Bean
    @Order(value=-2147483648)
    public HttpReader getHttpReader() {
        return new HttpReader();
    }

    @Bean
    public static SpecifiedBeanPostProcessor httpMessageConvertersPostProcessor() {
        return new SpecifiedBeanPostProcessor<HttpMessageConverters>(){

            public int getOrder() {
                return 0;
            }

            public Class<HttpMessageConverters> getBeanType() {
                return HttpMessageConverters.class;
            }

            public Object postProcessBeforeInitialization(HttpMessageConverters bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(HttpMessageConverters bean, String beanName) throws BeansException {
                List converters = bean.getConverters();
                return new CustomHttpMessageConverters(false, (Collection)(converters == null ? Collections.emptyList() : converters));
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpMessageConverters messageConverters(ObjectProvider<HttpMessageConverter<?>> converters) {
        return new HttpMessageConverters((Collection)converters.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    @ConditionalOnBean(value={ReactiveInterceptor.class})
    public WebFluxRegistrations getWebFluxRegistrations() {
        return new WebFluxRegistrations(){

            public RequestMappingHandlerAdapter getRequestMappingHandlerAdapter() {
                return new CustomRequestMappingHandlerAdapter();
            }
        };
    }

    @Bean
    public MonitorWebFilter getMonitorWebFilter() {
        return new MonitorWebFilter();
    }

    @Bean
    public Validator validator() {
        ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).addProperty("hibernate.validator.fail_fast", "true")).buildValidatorFactory();
        return validatorFactory.getValidator();
    }
}

