/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.kjj.ddmessage.template;

import cn.com.duiba.kjy.base.api.utils.HttpResult;
import cn.com.duibaboot.kjj.ddmessage.template.DDMessageTemplate;
import cn.com.duibaboot.kjj.ddmessage.template.bean.DDMessageContent;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DDMessageTemplateImpl
implements DDMessageTemplate {
    private static final Logger log = LoggerFactory.getLogger(DDMessageTemplateImpl.class);
    @Resource
    private CloseableHttpClient httpClient;
    private String liveWarnUrl;
    private String testWarnUrl;
    private String oaWarnUrl;

    private void sendMessage(String url, DDMessageContent ddMessageContent) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("msgtype", "text");
        HashMap<String, String> text = new HashMap<String, String>();
        text.put("content", ddMessageContent.toString());
        param.put("text", text);
        HashMap<String, Object> at = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(ddMessageContent.getAtUserPhone())) {
            at.put("isAtAll", ddMessageContent.getAtAll());
        }
        at.put("atMobiles", ddMessageContent.getAtUserPhone());
        param.put("at", at);
        HttpResult result = this.post(url, JSON.toJSONString(param));
        JSONObject responseBody = JSON.parseObject((String)result.getContent());
        if (responseBody.getInteger("errcode") != 0) {
            log.error("send ding ding message error ! message = {}, result={}", (Object)ddMessageContent, (Object)result);
        }
    }

    @Override
    public void sendMessage2LiveWarn(DDMessageContent ddMessageContent) {
        this.sendMessage(this.liveWarnUrl, ddMessageContent);
    }

    @Override
    public void sendMessageCesWarn(DDMessageContent ddMessageContent) {
        this.sendMessage(this.testWarnUrl, ddMessageContent);
    }

    @Override
    public void sendMessageOaWarn(DDMessageContent ddMessageContent) {
        this.sendMessage(this.oaWarnUrl, ddMessageContent);
    }

    private HttpResult post(String url, String requestBody) {
        log.info("\u53d1\u9001post\u8bf7\u6c42 URL= {} params = {}", (Object)url, (Object)requestBody);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(RequestConfig.custom().setSocketTimeout(6000).setConnectionRequestTimeout(1000).setConnectTimeout(2000).build());
        StringEntity stringEntity = new StringEntity(requestBody, StandardCharsets.UTF_8);
        stringEntity.setContentEncoding(StandardCharsets.UTF_8.toString());
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return this.doSendRequest((HttpRequestBase)httpPost);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpResult doSendRequest(HttpRequestBase request) {
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            int statusCode = response.getStatusLine().getStatusCode();
            HttpResult result = new HttpResult(statusCode);
            if (statusCode < 300) {
                result.setContent(IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
            }
            HttpResult httpResult = result;
            return httpResult;
        }
        catch (Exception e) {
            log.error(" httpclient \u53d1\u9001\u8bf7\u6c42\u65f6\u5f02\u5e38 \uff1a", (Throwable)e);
            return HttpResult.fail();
        }
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getLiveWarnUrl() {
        return this.liveWarnUrl;
    }

    public String getTestWarnUrl() {
        return this.testWarnUrl;
    }

    public String getOaWarnUrl() {
        return this.oaWarnUrl;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setLiveWarnUrl(String liveWarnUrl) {
        this.liveWarnUrl = liveWarnUrl;
    }

    public void setTestWarnUrl(String testWarnUrl) {
        this.testWarnUrl = testWarnUrl;
    }

    public void setOaWarnUrl(String oaWarnUrl) {
        this.oaWarnUrl = oaWarnUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DDMessageTemplateImpl)) {
            return false;
        }
        DDMessageTemplateImpl other = (DDMessageTemplateImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CloseableHttpClient this$httpClient = this.getHttpClient();
        CloseableHttpClient other$httpClient = other.getHttpClient();
        if (this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient)) {
            return false;
        }
        String this$liveWarnUrl = this.getLiveWarnUrl();
        String other$liveWarnUrl = other.getLiveWarnUrl();
        if (this$liveWarnUrl == null ? other$liveWarnUrl != null : !this$liveWarnUrl.equals(other$liveWarnUrl)) {
            return false;
        }
        String this$testWarnUrl = this.getTestWarnUrl();
        String other$testWarnUrl = other.getTestWarnUrl();
        if (this$testWarnUrl == null ? other$testWarnUrl != null : !this$testWarnUrl.equals(other$testWarnUrl)) {
            return false;
        }
        String this$oaWarnUrl = this.getOaWarnUrl();
        String other$oaWarnUrl = other.getOaWarnUrl();
        return !(this$oaWarnUrl == null ? other$oaWarnUrl != null : !this$oaWarnUrl.equals(other$oaWarnUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DDMessageTemplateImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CloseableHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        String $liveWarnUrl = this.getLiveWarnUrl();
        result = result * 59 + ($liveWarnUrl == null ? 43 : $liveWarnUrl.hashCode());
        String $testWarnUrl = this.getTestWarnUrl();
        result = result * 59 + ($testWarnUrl == null ? 43 : $testWarnUrl.hashCode());
        String $oaWarnUrl = this.getOaWarnUrl();
        result = result * 59 + ($oaWarnUrl == null ? 43 : $oaWarnUrl.hashCode());
        return result;
    }

    public String toString() {
        return "DDMessageTemplateImpl(httpClient=" + this.getHttpClient() + ", liveWarnUrl=" + this.getLiveWarnUrl() + ", testWarnUrl=" + this.getTestWarnUrl() + ", oaWarnUrl=" + this.getOaWarnUrl() + ")";
    }
}

