/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.kjj.oss.conf;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="apollo")
public class OssProps {
    private static final Logger log = LoggerFactory.getLogger(OssProps.class);
    public static final String prefix = "apollo";
    private Map<String, OssClientProps> oss = new LinkedHashMap<String, OssClientProps>();

    public Map<String, OssClientProps> getOss() {
        return this.oss;
    }

    public void setOss(Map<String, OssClientProps> oss) {
        this.oss = oss;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OssProps)) {
            return false;
        }
        OssProps other = (OssProps)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, OssClientProps> this$oss = this.getOss();
        Map<String, OssClientProps> other$oss = other.getOss();
        return !(this$oss == null ? other$oss != null : !((Object)this$oss).equals(other$oss));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OssProps;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, OssClientProps> $oss = this.getOss();
        result = result * 59 + ($oss == null ? 43 : ((Object)$oss).hashCode());
        return result;
    }

    public String toString() {
        return "OssProps(oss=" + this.getOss() + ")";
    }

    static class OssClientProps {
        private String accessId;
        private String accessKey;
        private String endPoint;
        private String bucketName;
        private String CDNDomain;
        private Integer connectTimeOut = 30000;
        private Integer maxErrorRetry = 1;
        private boolean privateBucket;

        public OSSClient newInstance() {
            try {
                DefaultCredentialProvider credentialProvider = new DefaultCredentialProvider(this.accessId, this.accessKey);
                ClientConfiguration clientConfiguration = new ClientConfiguration();
                clientConfiguration.setConnectionTimeout(this.connectTimeOut.intValue());
                clientConfiguration.setMaxErrorRetry(this.maxErrorRetry.intValue());
                return new OSSClient(this.endPoint, (CredentialsProvider)credentialProvider, clientConfiguration);
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316ossClient\u53d1\u751f\u5f02\u5e38\uff1aoss props={}", (Object)this, (Object)e);
                return null;
            }
        }

        public String getAccessId() {
            return this.accessId;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getEndPoint() {
            return this.endPoint;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getCDNDomain() {
            return this.CDNDomain;
        }

        public Integer getConnectTimeOut() {
            return this.connectTimeOut;
        }

        public Integer getMaxErrorRetry() {
            return this.maxErrorRetry;
        }

        public boolean isPrivateBucket() {
            return this.privateBucket;
        }

        public void setAccessId(String accessId) {
            this.accessId = accessId;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public void setCDNDomain(String CDNDomain) {
            this.CDNDomain = CDNDomain;
        }

        public void setConnectTimeOut(Integer connectTimeOut) {
            this.connectTimeOut = connectTimeOut;
        }

        public void setMaxErrorRetry(Integer maxErrorRetry) {
            this.maxErrorRetry = maxErrorRetry;
        }

        public void setPrivateBucket(boolean privateBucket) {
            this.privateBucket = privateBucket;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OssClientProps)) {
                return false;
            }
            OssClientProps other = (OssClientProps)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accessId = this.getAccessId();
            String other$accessId = other.getAccessId();
            if (this$accessId == null ? other$accessId != null : !this$accessId.equals(other$accessId)) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$endPoint = this.getEndPoint();
            String other$endPoint = other.getEndPoint();
            if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$CDNDomain = this.getCDNDomain();
            String other$CDNDomain = other.getCDNDomain();
            if (this$CDNDomain == null ? other$CDNDomain != null : !this$CDNDomain.equals(other$CDNDomain)) {
                return false;
            }
            Integer this$connectTimeOut = this.getConnectTimeOut();
            Integer other$connectTimeOut = other.getConnectTimeOut();
            if (this$connectTimeOut == null ? other$connectTimeOut != null : !((Object)this$connectTimeOut).equals(other$connectTimeOut)) {
                return false;
            }
            Integer this$maxErrorRetry = this.getMaxErrorRetry();
            Integer other$maxErrorRetry = other.getMaxErrorRetry();
            if (this$maxErrorRetry == null ? other$maxErrorRetry != null : !((Object)this$maxErrorRetry).equals(other$maxErrorRetry)) {
                return false;
            }
            return this.isPrivateBucket() == other.isPrivateBucket();
        }

        protected boolean canEqual(Object other) {
            return other instanceof OssClientProps;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accessId = this.getAccessId();
            result = result * 59 + ($accessId == null ? 43 : $accessId.hashCode());
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $endPoint = this.getEndPoint();
            result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $CDNDomain = this.getCDNDomain();
            result = result * 59 + ($CDNDomain == null ? 43 : $CDNDomain.hashCode());
            Integer $connectTimeOut = this.getConnectTimeOut();
            result = result * 59 + ($connectTimeOut == null ? 43 : ((Object)$connectTimeOut).hashCode());
            Integer $maxErrorRetry = this.getMaxErrorRetry();
            result = result * 59 + ($maxErrorRetry == null ? 43 : ((Object)$maxErrorRetry).hashCode());
            result = result * 59 + (this.isPrivateBucket() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "OssProps.OssClientProps(accessId=" + this.getAccessId() + ", accessKey=" + this.getAccessKey() + ", endPoint=" + this.getEndPoint() + ", bucketName=" + this.getBucketName() + ", CDNDomain=" + this.getCDNDomain() + ", connectTimeOut=" + this.getConnectTimeOut() + ", maxErrorRetry=" + this.getMaxErrorRetry() + ", privateBucket=" + this.isPrivateBucket() + ")";
        }
    }
}

