package cn.com.duiba.kjy.base.api.dto.clue.user;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 绑定后，用户信息缓存，用于红包和抽奖
 * redis key：直播ID+直播用户ID
 * @author lizhi
 * @date 2021/1/27 7:50 下午
 */
@Data
public class LiveClueUserInfoDto implements Serializable {

    private static final long serialVersionUID = -6938266289391954931L;

    /**
     * 业务方用户ID
     */
    private String bUid;

    /**
     * 授权手机号
     * authPhone
     */
    private String aP;

    /**
     * 微信昵称
     * nickname
     */
    private String nn;

    /**
     * 是否是黑名单用户，0-不是，1-是
     * black
     */
    private int b;

    /**
     * 用户绑定的所有直播，key：liveId，value：绑定的代理Id
     */
    private Map<Long, Long> iMap;
}
