package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.kjy.base.customweb.util.PerfTestUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestFootMarker;

import javax.annotation.Resource;

/**
 * @author dugq
 * @date 2021/5/24 1:31 下午
 * 压测请求处理压测标记
 */
public class KjjPerfFilter implements CustomFilter{
    @Resource
    private PerfTestFootMarker perfTestFootMarker;

    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        InternalPerfTestContext.markAsNormal();
        boolean isPerfTestMode = PerfTestUtil.isPerfTestRequest(httpRequest);
        if(isPerfTestMode) {
            doInPerfTestContext(customFilterChain, httpRequest, response);
        }else{
            //非压测请求，直接干就完事了
            customFilterChain.filter(httpRequest, response);
        }
    }

    /**
     * 压测请求处理过程
     */
    private void doInPerfTestContext(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        String perfTestSceneId = PerfTestUtil.getPerfTestSceneId(httpRequest);
        boolean isTestCluster = PerfTestUtil.isPerfTestCluster(httpRequest);
        InternalPerfTestContext.markAsPerfTest(perfTestSceneId, isTestCluster);
        perfTestFootMarker.markApp();
        try {
            customFilterChain.filter(httpRequest, response);
        }finally {
            InternalPerfTestContext.markAsNormal();
        }
    }
}
