package cn.com.duiba.kjy.base.api.bean.login;

import java.io.Serializable;
import java.util.Objects;

/**
 * 用户身份的消息体。cookie中value的原始值
 * @see cn.com.duiba.kjy.base.api.enums.login.UserSourceEnum
 * @author dugq
 * @date 2021/11/29 3:25 下午
 */
public class LoginBean implements Serializable {
    private static final long serialVersionUID = -6349141124904133967L;

    /**
     * 登录时间
     * 兼容旧的业务所必须的
     * 目前只用于解密参数，兼容老版本tku，不支持set
     */
    @Deprecated
    private Long time;


    /**
     * 登录时间
     */
    private Long disableTime;

    /**
     * @see cn.com.duiba.user.service.api.enums.user.PlatformTypeEnum
     */
    private Integer PlatformType;

    public Integer getPlatformType() {
        return PlatformType;
    }

    public void setPlatformType(Integer platformType) {
        PlatformType = platformType;
    }

    public Long getDisableTime() {
        if (Objects.nonNull(disableTime)){
            return disableTime;
        }
        return time;
    }

    public void setDisableTime(Long disableTime) {
        this.disableTime = disableTime;
    }
}
