package cn.com.duiba.kjy.base.api.bean.lottery;

import cn.com.duiba.kjy.base.api.bean.es.BaseEsBean;
import cn.com.duiba.kjy.base.api.enums.lottery.LiveLotteryDrawTypeEnum;
import io.searchbox.annotations.JestId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author zhanghuifeng
 * date 2021/1/28-13:46
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LiveRewardLotteryCollectEsBean extends BaseEsBean {

    private static final long serialVersionUID = 1878607550100591550L;

    /**
     * es主键ID:
     * 直播ID_直播用户ID
     */
    @JestId
    private String id;
    /**
     * 直播用户ID
     */
    private Long uid;

    /**
     * 抽奖码数量
     */
    private Integer lcNum;

    /**
     * 抽奖码得分
     */
    private Integer lcSco;

    /**
     * 时长得分
     */
    private Integer drSco;

    /**
     * 提交表单得分（包括选项额外得分）
     */
    private Integer fmSco;

    /**
     * 总得分
     */
    private Integer tlSco;

    /**
     * 直播ID
     */
    private Long lid;

    /**
     * 省市区划代码
     */
    private List<Integer> ctCode;

    /**
     * 是否授权手机号
     */
    private Integer isPh;

    /**
     * 是否在线索员名下
     */
    private Integer isCl;

    /**
     * 是否是黑名单用户
     */
    private Integer isBk;

    /**
     * 是否是公司员工
     */
    private Integer isCmy;

    /**
     * 昵称是否合法
     */
    private Integer isNi;

    /**
     * 是否到场
     */
    private Integer isPt;

    /**
     * 已中奖类型数组
     * @see LiveLotteryDrawTypeEnum
     */
    private List<Integer> dwType;

    /**
     * 是否是直接邀请
     */
    private Integer isDly;

    /**
     * 用户手机号
     */
    private String phone;

    /**
     * 代理人ID
     */
    private Long aid;

    /**
     * 团队ID
     */
    private Long tid;
}
