package cn.com.duiba.kjy.base.customweb.util;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import io.netty.handler.codec.http.cookie.Cookie;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @author dugq
 * @date 2021/10/14 7:42 下午
 */
public class ServiceGroupUtils {

    private ServiceGroupUtils() {
    }

    public static final String DUIBA_SERVICE_GROUP_KEY = "_duibaServiceGroupKey";
    //开发环境获取ip作为服务分组id，以实现优先调用开发者本地服务的逻辑,以提升开发效率
    public static final String DUIBA_SERVICE_GROUP_IP_PREFIX = "dev_ip_";

    // 环境变量中服务分组的key
    public static final String ENV_DUIBA_SERVICE_GROUP_KEY = "DUIBA_SERVICE_GROUP_KEY";

    /**
     * 从request中获取服务分组标识，服务分组标识可以再以下任一地方
     * <br/>
     * cookie 中有 _duibaServiceGroupKey
     * <br/>
     * header 中有 _duibaServiceGroupKey
     * @param request
     * @return 服务分组标识，可能为nul
     */
    public static String getDuibaServiceGroupKey(KjjHttpRequest request) {
        String groupKey = null;
        List<Cookie> cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (DUIBA_SERVICE_GROUP_KEY.equals(cookie.name())) {
                    groupKey = cookie.value();
                }
            }
        }
        if (StringUtils.isBlank(groupKey)) {
            groupKey = request.getHeader(DUIBA_SERVICE_GROUP_KEY);
        }
        return groupKey;
    }
}
