/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.condition;

import cn.com.duiba.kjy.base.customweb.util.CorsUtils;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.condition.AbstractRequestCondition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestMethodsRequestCondition
extends AbstractRequestCondition<RequestMethodsRequestCondition> {
    private static final Map<String, RequestMethodsRequestCondition> requestMethodConditionCache = new HashMap<String, RequestMethodsRequestCondition>(RequestMethod.values().length);
    private final Set<RequestMethod> methods;

    public RequestMethodsRequestCondition(RequestMethod ... requestMethods) {
        this(Arrays.asList(requestMethods));
    }

    private RequestMethodsRequestCondition(Collection<RequestMethod> requestMethods) {
        this.methods = Collections.unmodifiableSet(new LinkedHashSet<RequestMethod>(requestMethods));
    }

    public Set<RequestMethod> getMethods() {
        return this.methods;
    }

    @Override
    protected Collection<RequestMethod> getContent() {
        return this.methods;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public RequestMethodsRequestCondition combine(RequestMethodsRequestCondition other) {
        LinkedHashSet<RequestMethod> set = new LinkedHashSet<RequestMethod>(this.methods);
        set.addAll(other.methods);
        return new RequestMethodsRequestCondition(set);
    }

    @Override
    @Nullable
    public boolean getMatchingCondition(KjjHttpRequest request) {
        if (CorsUtils.isPreFlightRequest(request)) {
            return true;
        }
        if (this.getMethods().isEmpty()) {
            return true;
        }
        return this.matchRequestMethod(request.getMethod());
    }

    @Nullable
    private boolean matchRequestMethod(String httpMethodValue) {
        try {
            RequestMethod requestMethod = RequestMethod.valueOf((String)httpMethodValue);
            if (this.getMethods().contains(requestMethod)) {
                return true;
            }
            if (requestMethod.equals((Object)RequestMethod.HEAD) && this.getMethods().contains(RequestMethod.GET)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int compareTo(RequestMethodsRequestCondition other, KjjHttpRequest request) {
        if (other.methods.size() != this.methods.size()) {
            return other.methods.size() - this.methods.size();
        }
        if (this.methods.size() == 1) {
            if (this.methods.contains(RequestMethod.HEAD) && other.methods.contains(RequestMethod.GET)) {
                return -1;
            }
            if (this.methods.contains(RequestMethod.GET) && other.methods.contains(RequestMethod.HEAD)) {
                return 1;
            }
        }
        return 0;
    }

    static {
        for (RequestMethod method : RequestMethod.values()) {
            requestMethodConditionCache.put(method.name(), new RequestMethodsRequestCondition(method));
        }
    }
}

