/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.reactive.adaptor;

import cn.com.duiba.kjy.base.reactive.interceptor.ReactiveInterceptor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CustomRequestMappingHandlerAdapter
extends RequestMappingHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(CustomRequestMappingHandlerAdapter.class);
    @Resource
    private List<ReactiveInterceptor> interceptorList;
    public static final MethodParameter HANDLER_FUNCTION_RETURN_TYPE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        try {
            Object result = this.doBefore(exchange, handlerMethod);
            if (Objects.nonNull(result)) {
                Mono mono = Mono.just((Object)new HandlerResult((Object)handlerMethod, result, HANDLER_FUNCTION_RETURN_TYPE));
                return mono;
            }
            Mono mono = super.handle(exchange, handler);
            return mono;
        }
        finally {
            this.doAfter(exchange, handlerMethod);
        }
    }

    @Nullable
    private Object doBefore(ServerWebExchange exchange, HandlerMethod handlerMethod) {
        if (CollectionUtils.isNotEmpty(this.interceptorList)) {
            for (ReactiveInterceptor interceptor : this.interceptorList) {
                Object result = interceptor.preHandle(exchange, handlerMethod);
                if (!Objects.nonNull(result)) continue;
                return result;
            }
        }
        return null;
    }

    private void doAfter(ServerWebExchange exchange, HandlerMethod handlerMethod) {
        if (CollectionUtils.isNotEmpty(this.interceptorList)) {
            for (ReactiveInterceptor interceptor : this.interceptorList) {
                try {
                    interceptor.afterHandle(exchange, handlerMethod);
                }
                catch (Throwable e) {
                    log.error("do after  handle in interceptor has error!", e);
                }
            }
        }
    }

    @ResponseBody
    public Object handle(Object result) {
        return result;
    }

    static {
        try {
            Method handle = CustomRequestMappingHandlerAdapter.class.getMethod("handle", Object.class);
            HANDLER_FUNCTION_RETURN_TYPE = new MethodParameter(handle, -1);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }
}

