package cn.com.duiba.kjy.base.api.service.datasource;

import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpStatus;
import org.springframework.data.redis.core.StringRedisTemplate;

import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author dugq
 * @date 2021/4/23 10:32 上午
 */
public class DbMovingSwitchFilter implements Filter {
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private MovingDataSourceConfiguration movingDataSourceConfiguration;

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {

        if(request instanceof HttpServletRequest){
            final HttpServletRequest httpServletRequest = (HttpServletRequest) request;
            final String requestURI = httpServletRequest.getRequestURI();
            if (StringUtils.equals(requestURI,"/db/moving/on")){
                final String key = httpServletRequest.getParameter("key");
                if (StringUtils.isBlank(key)){
                    writeResponseJson(response, "NO redis KEY in request Param.");
                    return;
                }
                stringRedisTemplate.opsForValue().set(key,"1",1, TimeUnit.DAYS);
                writeResponseJson(response, "on success");
                return;
            }else if (StringUtils.equals(requestURI,"/db/moving/off")){
                final String key = httpServletRequest.getParameter("key");
                if (StringUtils.isBlank(key)){
                    writeResponseJson(response, "NO redis KEY in request Param.");
                    return;
                }
                stringRedisTemplate.delete(key);
                writeResponseJson(response, "off success");
                return;
            }else if (StringUtils.equals(requestURI,"/db/moving/list")){
                final Map<String, MovingDbProperties> db = movingDataSourceConfiguration.getDb();
                List<Map<String,String>> result = new LinkedList<>();
                for (Map.Entry<String, MovingDbProperties> dbPropertiesEntry : db.entrySet()) {
                    String oldDb = dbPropertiesEntry.getKey();
                    final String newDb = dbPropertiesEntry.getValue().getNewDataSource();
                    String redisKey = dbPropertiesEntry.getValue().getRedisKey();
                    final String redisValue = stringRedisTemplate.opsForValue().get(redisKey);
                    Map<String,String> map = new HashMap<>();
                    map.put("oldDb",oldDb);
                    map.put("newDb",newDb);
                    map.put("redisKey",redisKey);
                    map.put("redisValue",redisValue);
                    result.add(map);
                }
                writeResponseJson(response,result);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void writeResponseJson(ServletResponse response, Object message) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        ((HttpServletResponse) response).setStatus(HttpStatus.SC_OK);
        response.getWriter().println(JSON.toJSONString(message));
        response.getWriter().flush();
        response.getWriter().close();
    }

}
