package cn.com.duiba.kjy.base.customweb.web.bind;


import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

/**
 * @author dugq
 * @date 2021/3/24 1:33 上午
 * spring web
 * {@link org.springframework.web.method.support.HandlerMethodArgumentResolverComposite}
 * 启动时装载 32个映射器。我们当前只需要3个
 *
 */
public interface ArgsResolver {

    /**
     * 是否可以处理参数的判断
     * @param parameter 参数
     * @param handlerMappingClass
     * @param handlerMappingMethod
     * @return 是否可以处理
     */
    boolean canRead(Parameter parameter, Class<?> handlerMappingClass, Method handlerMappingMethod);

    /**
     * 具体处理参数映射，并返回参数对象
     * @param parameterBean 参数描述
     * @param httpRequest Http请求
     * @param response
     * @return 参数对象
     */
    Object doResolver(ParameterBean parameterBean, KjjHttpRequest httpRequest, KjjHttpResponse response) throws  Throwable;

    /**
     * 解析参数需要做一定的准备，可以在初始化时完成。以减少在实际调用时再实行的额外消耗。
     */
    default void prepareResolver(ParameterBean parameterBean,Class<?> handlerMappingClass, Method handlerMappingMethod){

    }
}
