package cn.com.duiba.kjy.base.api.utils.login;

import cn.com.duiba.kjy.base.api.bean.login.TkuBean;
import cn.com.duiba.kjy.base.api.enums.login.UserSourceEnum;

import java.util.Objects;

/**
 * 客集集业务专用的获取当前请求中用户信息的工具类
 * @author dugq
 * @date 2021/12/22 11:35 上午
 */
public class KjjRequestTool {

    private KjjRequestTool(){}

    public static Long getUserId(){
        TkuBean userInfo = BaseRequestTool.getUserInfo(UserSourceEnum.KJJ_ACCOUNT);
        if (Objects.isNull(userInfo)){
            return null;
        }
        return userInfo.getUid();
    }

    public static Boolean isLogin(){
        return BaseRequestTool.isLogin(UserSourceEnum.KJJ_ACCOUNT);
    }

    public static Boolean isNotLogin(){
        return !BaseRequestTool.isLogin(UserSourceEnum.KJJ_ACCOUNT);
    }

    /**
     * @return  {@link cn.com.duiba.user.service.api.enums.user.PlatformTypeEnum}
     */
    public static Integer getUserType(){
        TkuBean userInfo = BaseRequestTool.getUserInfo(UserSourceEnum.KJJ_ACCOUNT);
        if (Objects.isNull(userInfo)){
            return null;
        }
        return userInfo.getUidType();
    }

    /**
     * @return  登陆时的渠道ID
     */
    public static Long getChannel(){
        TkuBean userInfo = BaseRequestTool.getUserInfo(UserSourceEnum.KJJ_ACCOUNT);
        if (Objects.isNull(userInfo)){
            return null;
        }
        return userInfo.getChannelId();
    }

    public static TkuBean getUserInfo(){
        return BaseRequestTool.getUserInfo(UserSourceEnum.KJJ_ACCOUNT);
    }

    /**
     * 这里返回的时候登陆时候的sellerId，为空时并不能说明用户就不是代理人。
     * 建议在为null的时候，根据uid再去查询确认一次
     */
    public static Long getSellerId(){
        TkuBean userInfo = BaseRequestTool.getUserInfo(UserSourceEnum.KJJ_ACCOUNT);
        if (Objects.isNull(userInfo)){
            return null;
        }
        return userInfo.getSid();
    }
}
