package cn.com.duiba.kjy.base.api.utils.login;

import cn.com.duiba.kjy.base.api.bean.login.LiveAuthBean;
import cn.com.duiba.kjy.base.api.enums.login.UserSourceEnum;

import java.util.Objects;

/**
 * 直播业务系统专用的用户登陆信息工具类
 * @author dugq
 * @date 2021/12/22 11:41 上午
 */
public class LiveRequestTool {
    private static final UserSourceEnum LIVE_SOURCE = UserSourceEnum.KJJ_LIVE;

    private LiveRequestTool(){}

    /**
     * tb_users表ID
     */
    public static Long getUserId(){
        LiveAuthBean userInfo = BaseRequestTool.getUserInfo(LIVE_SOURCE);
        if (Objects.isNull(userInfo)){
            return null;
        }
        return Long.valueOf(userInfo.getThirdPartUId());
    }

    /**
     * tb_live_user表ID
     */
    public static Long getLiveUserId(){
        LiveAuthBean userInfo = BaseRequestTool.getUserInfo(LIVE_SOURCE);
        if (Objects.isNull(userInfo)){
            return null;
        }
        return userInfo.getLiveUserId();
    }

    public static Boolean isLogin(){
        return BaseRequestTool.isLogin(LIVE_SOURCE);
    }

    public static Boolean isNotLogin(){
        return !BaseRequestTool.isLogin(LIVE_SOURCE);
    }

    /**
     * @return  {@link cn.com.duiba.user.service.api.enums.user.PlatformTypeEnum}
     */
    public static Integer getUserType(){
        LiveAuthBean userInfo = BaseRequestTool.getUserInfo(LIVE_SOURCE);
        if (Objects.isNull(userInfo)){
            return null;
        }
        return userInfo.getUidType();
    }


    public static LiveAuthBean getUserInfo(){
        return BaseRequestTool.getUserInfo(LIVE_SOURCE);
    }

}
