package cn.com.duiba.kjy.base.api.enums;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 *<a href="http://cf.dui88.com/pages/viewpage.action?pageId=132499328">前端技术方案</a> <br/>
 *<a href="http://cf.dui88.com/pages/viewpage.action?pageId=132492647">后端技术方案</a>
 * @author dugq
 * @date 2021/12/21 3:29 下午
 */
@Getter
@Slf4j
public enum ProviderChannelEnum {
    //channel_id = tb_official_account表
    WECHAT_OA(1,"/oax","个微公众号"),
    WX_WORK(2,"/qywx","企微应用"),
    THIRD_PARTY_APP(2,"/app","第三方APP"),
    ;
    private final Integer code;
    private final String urlPrefix;
    private final String desc;

    ProviderChannelEnum(Integer code,String urlPrefix, String desc) {
        this.code = code;
        this.urlPrefix = urlPrefix;
        this.desc = desc;
    }

    private static final Map<Integer, ProviderChannelEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(ProviderChannelEnum::getCode, Function.identity(), (v1, v2) -> {
                log.error("ProviderChannelEnum, type distinct, type={}", v2.getCode());
                return v2;
            }))
    );

    /**
     * 根据状态获取枚举
     * @param code 状态
     * @return 枚举
     */
    public static ProviderChannelEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    /**
     * 获取拼接链接.
     * 如果渠道为空，则返回原链接
     * @param channelId 渠道ID
     * @param subUrl 原始链接
     * @return 新的带有平台的链接
     */
    public String getUrl(String channelId,String subUrl){
        if (StringUtils.isBlank(channelId)){
            return subUrl;
        }
        return urlPrefix + channelId + subUrl;
    }

    public String getUrl(Long channelId,String subUrl){
        if (Objects.isNull(channelId)){
            return subUrl;
        }
        return urlPrefix +"/"+IdMakeUtil.encodingId(channelId) + subUrl;
    }
}
